/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.service.vanity;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNodeImpl;
import org.jahia.modules.graphql.provider.dxm.node.SpecializedType;
import org.jahia.services.content.JCRNodeWrapper;

@GraphQLName(value="VanityUrl")
@GraphQLDescription(value="GraphQL representation of a vanity URL")
@SpecializedType(value="jnt:vanityUrl")
public class GqlJcrVanityUrl
extends GqlJcrNodeImpl
implements GqlJcrNode {
    public GqlJcrVanityUrl(JCRNodeWrapper vanityNode) {
        super(vanityNode);
    }

    @GraphQLField
    @GraphQLName(value="url")
    @GraphQLDescription(value="The vanity URL")
    public String getUrl() {
        return this.getNode().getPropertyAsString("j:url");
    }

    @GraphQLField
    @GraphQLName(value="language")
    @GraphQLDescription(value="The language of the content object to which the vanity URL maps to")
    public String getLanguage() {
        return this.getNode().getPropertyAsString("jcr:language");
    }

    @GraphQLField
    @GraphQLName(value="targetNode")
    @GraphQLDescription(value="The node targeted by this vanity URL")
    public GqlJcrNode getTargetNode() {
        return this.getParent().getParent();
    }

    @GraphQLField
    @GraphQLName(value="active")
    @GraphQLDescription(value="true if the URL mapping is activated or false if it is not activated")
    public boolean isActive() {
        try {
            return this.getNode().hasProperty("j:active") && this.getNode().getProperty("j:active").getBoolean();
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="default")
    @GraphQLDescription(value="true whether this URL mapping is the default one for the language")
    public boolean isDefault() {
        try {
            return this.getNode().hasProperty("j:default") && this.getNode().getProperty("j:default").getBoolean();
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }
}

