/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.service.tags;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.node.NodeQueryExtensions;
import org.jahia.modules.graphql.provider.dxm.service.tags.GqlTagNode;
import org.jahia.modules.graphql.provider.dxm.service.tags.GqlTagNodeImpl;
import org.jahia.osgi.BundleUtils;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.tags.TaggingService;

@GraphQLName(value="JCRTags")
@GraphQLDescription(value="JCR Queries")
public class GqlTagQuery {
    @GraphQLField
    @GraphQLName(value="suggest")
    @GraphQLDescription(value="Handles suggestion tags queries")
    public List<GqlTagNode> suggestTags(@GraphQLName(value="prefix") @GraphQLNonNull @GraphQLDescription(value="The prefix of the tags") String prefix, @GraphQLName(value="limit") @GraphQLNonNull @GraphQLDescription(value="Max number of tags to get") Long limit, @GraphQLName(value="startPath") @GraphQLNonNull @GraphQLDescription(value="The root node to start the search") String startPath, @GraphQLName(value="minCount") @GraphQLDescription(value="Minimal occurrences to return a tag") Long minCount, @GraphQLName(value="offset") @GraphQLDescription(value="Offset value") Long offset, @GraphQLName(value="sortByCount") @GraphQLDescription(value="Sort the tags by occurrences") Boolean sortByCount) throws RepositoryException {
        try {
            JCRSessionWrapper jcrSessionWrapper = this.getSession();
            TaggingService taggingService = (TaggingService)BundleUtils.getOsgiService(TaggingService.class, null);
            Map suggestions = taggingService.getTagsSuggester().suggest(prefix, startPath, minCount, limit, offset, (sortByCount != null ? sortByCount : Boolean.FALSE).booleanValue(), jcrSessionWrapper);
            return suggestions.entrySet().stream().map(GqlTagNodeImpl::new).collect(Collectors.toList());
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    private JCRSessionWrapper getSession() throws RepositoryException {
        return JCRSessionFactory.getInstance().getCurrentUserSession(NodeQueryExtensions.Workspace.EDIT.getValue());
    }
}

