/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.security;

import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.exceptions.GraphQLAnnotationsException;
import graphql.annotations.processor.retrievers.GraphQLFieldRetriever;
import graphql.schema.AsyncDataFetcher;
import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import org.jahia.modules.graphql.provider.dxm.config.DXGraphQLConfig;
import org.jahia.modules.graphql.provider.dxm.security.GraphQLAsync;
import org.jahia.modules.graphql.provider.dxm.security.GraphQLRequiresPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaGraphQLFieldRetriever
extends GraphQLFieldRetriever {
    private static Logger logger = LoggerFactory.getLogger(JahiaGraphQLFieldRetriever.class);
    private DXGraphQLConfig dxGraphQLConfig;
    private GraphQLFieldRetriever graphQLFieldRetriever;
    private Executor executor;

    public JahiaGraphQLFieldRetriever(DXGraphQLConfig dxGraphQLConfig, GraphQLFieldRetriever graphQLFieldRetriever, Executor executor) {
        this.dxGraphQLConfig = dxGraphQLConfig;
        this.graphQLFieldRetriever = graphQLFieldRetriever;
        this.executor = executor;
    }

    public GraphQLFieldDefinition getField(String parentName, Method method, ProcessingElementsContainer container) throws GraphQLAnnotationsException {
        String realParentName = (String)container.getProcessing().peek();
        GraphQLFieldDefinition definition = this.graphQLFieldRetriever.getField(realParentName, method, container);
        this.wrap(method, parentName, container, definition);
        return definition;
    }

    public GraphQLFieldDefinition getField(String parentName, Field field, ProcessingElementsContainer container) throws GraphQLAnnotationsException {
        GraphQLFieldDefinition definition = this.graphQLFieldRetriever.getField(parentName, field, container);
        this.wrap(field, parentName, container, definition);
        return definition;
    }

    private void wrap(AnnotatedElement element, String parentName, ProcessingElementsContainer container, GraphQLFieldDefinition definition) {
        GraphQLAsync async;
        GraphQLRequiresPermission ann = element.getAnnotation(GraphQLRequiresPermission.class);
        if (ann != null) {
            String key = (String)container.getProcessing().peek() + "." + definition.getName();
            logger.debug("Adding permission : {} = {}", (Object)key, (Object)ann.value());
            this.dxGraphQLConfig.getPermissions().put(key, ann.value());
        }
        if ((async = element.getAnnotation(GraphQLAsync.class)) != null) {
            DataFetcher dataFetcher = container.getCodeRegistryBuilder().getDataFetcher(FieldCoordinates.coordinates((String)parentName, (String)definition.getName()), definition);
            AsyncDataFetcher asyncDataFetcher = AsyncDataFetcher.async((DataFetcher)dataFetcher, (Executor)this.executor);
            logger.debug("Creating async DataFetcher : {} {}", (Object)parentName, (Object)definition.getName());
            container.getCodeRegistryBuilder().dataFetcher(FieldCoordinates.coordinates((String)parentName, (String)definition.getName()), (DataFetcher)asyncDataFetcher);
        }
    }

    public GraphQLInputObjectField getInputField(Method method, ProcessingElementsContainer container, String parentName) throws GraphQLAnnotationsException {
        return this.graphQLFieldRetriever.getInputField(method, container, parentName);
    }

    public GraphQLInputObjectField getInputField(Field field, ProcessingElementsContainer container, String parentName) throws GraphQLAnnotationsException {
        return this.graphQLFieldRetriever.getInputField(field, container, parentName);
    }
}

