/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.sdl.validation;

import graphql.schema.DataFetchingEnvironment;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldSorterInput;
import org.jahia.modules.graphql.provider.dxm.predicate.SorterHelper;
import org.jahia.modules.graphql.provider.dxm.sdl.SDLUtil;

public class ArgumentValidator {
    public static boolean validate(ArgumentNames argumentNames, DataFetchingEnvironment environment) {
        switch (argumentNames) {
            case VALUE: {
                return ArgumentValidator.validateArgumentsExistence(ArgumentNames.VALUE.getName(), environment);
            }
            case DATE_RANGE: {
                return ArgumentValidator.validateDateRangeArguments(environment);
            }
            case SORT_BY: {
                return ArgumentValidator.validateSortByArguments(environment);
            }
        }
        return false;
    }

    private static boolean validateArgumentsExistence(String argumentName, DataFetchingEnvironment environment) {
        if (SDLUtil.getArgument(argumentName, environment) == null) {
            throw new DataFetchingException(" Argument '" + argumentName + "' is missing");
        }
        return true;
    }

    private static boolean validateSortByArguments(DataFetchingEnvironment environment) {
        FieldSorterInput sorterInput = ArgumentValidator.getFieldSorterInput(environment);
        if (sorterInput == null) {
            return true;
        }
        if (!SDLUtil.isFieldInWrappedTypeFields(sorterInput.getFieldName(), environment).booleanValue()) {
            throw new DataFetchingException("Cannot sort by invalid field name '" + sorterInput.getFieldName() + "'");
        }
        return true;
    }

    private static boolean validateDateRangeArguments(DataFetchingEnvironment environment) {
        String after = (String)SDLUtil.getArgument(ArgumentNames.AFTER.getName(), environment);
        String before = (String)SDLUtil.getArgument(ArgumentNames.BEFORE.getName(), environment);
        Integer lastDays = (Integer)SDLUtil.getArgument(ArgumentNames.LASTDAYS.getName(), environment);
        if (SDLUtil.getArgumentsSize(environment) == 0 || lastDays == null && StringUtils.isBlank((String)after) && StringUtils.isBlank((String)before)) {
            throw new DataFetchingException("By date range data fetcher needs at least one argument of 'after', 'before' or 'lastDays'");
        }
        if (!(lastDays == null || StringUtils.isBlank((String)after) && StringUtils.isBlank((String)before))) {
            throw new DataFetchingException("By date range data fetcher does not support argument 'lastDays' mixed with 'after' or 'before'");
        }
        return true;
    }

    public static FieldSorterInput getFieldSorterInput(DataFetchingEnvironment environment) {
        Map sortByFilter = (Map)SDLUtil.getArgument(ArgumentNames.SORT_BY.getName(), environment);
        return sortByFilter != null ? new FieldSorterInput((String)sortByFilter.get(ArgumentNames.FIELD_NAME.getName()), (SorterHelper.SortType)((Object)sortByFilter.get(ArgumentNames.SORT_TYPE.getName())), (Boolean)sortByFilter.get(ArgumentNames.IGNORE_CASE.getName())) : null;
    }

    public static enum ArgumentNames {
        VALUE("value"),
        DATE_RANGE("dateRange"),
        AFTER("after"),
        BEFORE("before"),
        LASTDAYS("lastDays"),
        SORT_BY("sortBy"),
        FIELD_NAME("fieldName"),
        SORT_TYPE("sortType"),
        IGNORE_CASE("ignoreCase");

        private String name;

        private ArgumentNames(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

