/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.sdl.types;

import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.time.LocalDateTime;
import java.util.Date;
import org.jahia.modules.graphql.provider.dxm.util.DateTimeUtils;

public class GraphQLDate
extends GraphQLScalarType {
    public static final String DATE_NAME = "Date";
    public static final String DATE_DESCRIPTION = "Date type";

    public GraphQLDate() {
        super(DATE_NAME, DATE_DESCRIPTION, (Coercing)new Coercing<Date, String>(){

            private Date convertImpl(Object input) {
                LocalDateTime localDateTime;
                if (input instanceof Long) {
                    return new Date((Long)input);
                }
                if (input instanceof String && (localDateTime = DateTimeUtils.parseDate((String)input)) != null) {
                    return DateTimeUtils.toDate(localDateTime);
                }
                return null;
            }

            public String serialize(Object input) {
                if (input instanceof Date) {
                    return DateTimeUtils.toISOString((Date)input);
                }
                Date result = this.convertImpl(input);
                if (result == null) {
                    throw new CoercingSerializeException("Invalid value '" + input + "' for Date");
                }
                return DateTimeUtils.toISOString(result);
            }

            public Date parseValue(Object input) {
                Date result = this.convertImpl(input);
                if (result == null) {
                    throw new CoercingParseValueException("Invalid value '" + input + "' for Date");
                }
                return result;
            }

            public Date parseLiteral(Object input) {
                if (!(input instanceof StringValue)) {
                    return null;
                }
                String value = ((StringValue)input).getValue();
                Date result = this.convertImpl(value);
                return result;
            }
        });
    }
}

