/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.sdl.parsing;

import graphql.Scalars;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.FieldDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.Value;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.modules.graphql.provider.dxm.sdl.parsing.SDLSchemaService;
import org.jahia.modules.graphql.provider.dxm.sdl.parsing.status.SDLDefinitionStatus;
import org.jahia.modules.graphql.provider.dxm.sdl.parsing.status.SDLDefinitionStatusType;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDLTypeChecker {
    private static Logger logger = LoggerFactory.getLogger(SDLTypeChecker.class);

    private SDLTypeChecker() {
    }

    public static SDLDefinitionStatus checkType(SDLSchemaService sdlSchemaService, TypeDefinition type, TypeDefinitionRegistry typeDefinitionRegistry) {
        if (type instanceof ObjectTypeDefinition) {
            ObjectTypeDefinition objectTypeDefinition = (ObjectTypeDefinition)type;
            SDLDefinitionStatus l = SDLTypeChecker.checkForFieldsConsistency(sdlSchemaService, objectTypeDefinition, typeDefinitionRegistry);
            if (l.getStatus() != SDLDefinitionStatusType.OK) {
                return l;
            }
            if (!objectTypeDefinition.getName().equals("Query")) {
                SDLTypeChecker.addDefaultFields(objectTypeDefinition);
            }
        }
        return SDLTypeChecker.checkForConsistencyWithJCR(type);
    }

    private static void addDefaultFields(ObjectTypeDefinition objectTypeDefinition) {
        List fieldDefinitions = objectTypeDefinition.getFieldDefinitions();
        FieldDefinition uuid = FieldDefinition.newFieldDefinition().name("uuid").type((Type)TypeName.newTypeName((String)Scalars.GraphQLString.getName()).build()).directive(Directive.newDirective().name("mapping").arguments(Collections.singletonList(Argument.newArgument().name("property").value((Value)new StringValue("identifier")).build())).build()).build();
        if (fieldDefinitions.stream().noneMatch(definition -> definition.getName().equals(uuid.getName()))) {
            fieldDefinitions.add(uuid);
        }
        FieldDefinition path = FieldDefinition.newFieldDefinition().name("path").type((Type)TypeName.newTypeName((String)Scalars.GraphQLString.getName()).build()).directive(Directive.newDirective().name("mapping").arguments(Collections.singletonList(Argument.newArgument().name("property").value((Value)new StringValue("path")).build())).build()).build();
        if (fieldDefinitions.stream().noneMatch(definition -> definition.getName().equals(path.getName()))) {
            fieldDefinitions.add(path);
        }
        FieldDefinition url = FieldDefinition.newFieldDefinition().name("url").type((Type)TypeName.newTypeName((String)Scalars.GraphQLString.getName()).build()).directive(Directive.newDirective().name("mapping").arguments(Collections.singletonList(Argument.newArgument().name("property").value((Value)new StringValue("url")).build())).build()).build();
        List directives = objectTypeDefinition.getDirectives();
        if (fieldDefinitions.stream().noneMatch(definition -> definition.getName().equals(url.getName())) && directives.stream().anyMatch(directive -> directive.getName().equals("mapping") && directive.getArguments().stream().anyMatch(arg -> arg.getName().equals("node") && SDLTypeChecker.isNodeOfTypeFile(((StringValue)arg.getValue()).getValue())))) {
            fieldDefinitions.add(url);
        }
    }

    private static boolean isNodeOfTypeFile(String type) {
        return Arrays.stream(type.split(",")).anyMatch(s -> {
            try {
                NodeTypeRegistry registry = NodeTypeRegistry.getInstance();
                return registry.hasNodeType(s.trim()) && registry.getNodeType(s.trim()).isNodeType("nt:file");
            }
            catch (RepositoryException ex) {
                return false;
            }
        });
    }

    private static SDLDefinitionStatus checkForConsistencyWithJCR(TypeDefinition typeDefinition) {
        SDLDefinitionStatus status = new SDLDefinitionStatus(typeDefinition.getName(), SDLDefinitionStatusType.OK);
        List directives = typeDefinition.getDirectives();
        for (Directive directive : directives) {
            ExtendedNodeType[] allTypes;
            if (!directive.getName().equals("mapping") || directive.getArgument("node") == null) continue;
            String[] jcrNodeTypes = ((StringValue)directive.getArgument("node").getValue()).getValue().split(",");
            try {
                allTypes = SDLTypeChecker.checkNodeTypes(jcrNodeTypes, status);
            }
            catch (NoSuchNodeTypeException ex) {
                return status;
            }
            List fields = ((ObjectTypeDefinition)typeDefinition).getFieldDefinitions();
            ArrayList<String> missingProps = new ArrayList<String>();
            ArrayList<String> missingChildren = new ArrayList<String>();
            SDLTypeChecker.checkMissingChildrenOrProps(allTypes, fields, missingProps, missingChildren);
            if (!missingProps.isEmpty()) {
                status.setStatusType(SDLDefinitionStatusType.MISSING_JCR_PROPERTY, StringUtils.join(missingProps, (String)","));
            }
            if (missingChildren.isEmpty()) continue;
            status.setStatusType(SDLDefinitionStatusType.MISSING_JCR_CHILD, StringUtils.join(missingChildren, (String)","));
        }
        return status;
    }

    public static void printStatuses(Map<String, SDLDefinitionStatus> statusMap) {
        statusMap.values().forEach(e -> logger.info(e.toString()));
    }

    private static SDLDefinitionStatus checkForFieldsConsistency(SDLSchemaService sdlSchemaService, ObjectTypeDefinition objectTypeDefinition, TypeDefinitionRegistry typeDefinitionRegistry) {
        if (objectTypeDefinition.getFieldDefinitions().isEmpty()) {
            return new SDLDefinitionStatus(objectTypeDefinition.getName(), SDLDefinitionStatusType.MISSING_FIELDS);
        }
        ArrayList l = new ArrayList();
        objectTypeDefinition.getFieldDefinitions().forEach(fieldDefinition -> {
            if (!typeDefinitionRegistry.getType(fieldDefinition.getType()).isPresent()) {
                l.add(fieldDefinition.getType().toString());
            }
        });
        if (!l.isEmpty()) {
            return new SDLDefinitionStatus(objectTypeDefinition.getName(), SDLDefinitionStatusType.MISSING_TYPE, StringUtils.join(l, (char)','));
        }
        if (sdlSchemaService != null) {
            return objectTypeDefinition.getFieldDefinitions().stream().map(fieldDefinition -> SDLTypeChecker.checkForInvalidFetcherDirective(sdlSchemaService, objectTypeDefinition, fieldDefinition)).filter(sdlDefinitionStatus -> sdlDefinitionStatus.getStatus() != SDLDefinitionStatusType.OK).findFirst().orElse(new SDLDefinitionStatus(objectTypeDefinition.getName(), SDLDefinitionStatusType.OK));
        }
        logger.warn("SDLSchemaService is unavailable! Cannot perform fetcher validation for schema!");
        return new SDLDefinitionStatus(objectTypeDefinition.getName(), SDLDefinitionStatusType.OK);
    }

    private static boolean hasProperty(ExtendedNodeType[] nodeTypes, String jcrPropertyName) {
        for (ExtendedNodeType type : nodeTypes) {
            if (type.getPropertyDefinition(jcrPropertyName) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean hasChildren(ExtendedNodeType[] nodeTypes, String jcrPropertyName) {
        for (ExtendedNodeType type : nodeTypes) {
            if (!type.getChildNodeDefinitionsAsMap().containsKey(jcrPropertyName)) continue;
            return true;
        }
        return false;
    }

    private static ExtendedNodeType[] checkNodeTypes(String[] jcrNodeTypes, SDLDefinitionStatus status) throws NoSuchNodeTypeException {
        ExtendedNodeType[] allTypes = null;
        for (String jcrNodeType : jcrNodeTypes) {
            if (!NodeTypeRegistry.getInstance().hasNodeType(jcrNodeType)) {
                status.setStatusType(SDLDefinitionStatusType.MISSING_JCR_NODE_TYPE, jcrNodeType);
                throw new NoSuchNodeTypeException();
            }
            ExtendedNodeType nodeType = NodeTypeRegistry.getInstance().getNodeType(jcrNodeType);
            Object[] superTypes = nodeType.getSupertypes();
            JahiaTemplatesPackage jahiaTemplatesPackage = nodeType.getTemplatePackage();
            if (jahiaTemplatesPackage != null) {
                status.setMappedTypeModuleId(jahiaTemplatesPackage.getBundle().getSymbolicName());
                status.setMappedTypeModuleName(jahiaTemplatesPackage.getName());
            }
            status.setMapsToType(jcrNodeType);
            allTypes = allTypes == null ? (ExtendedNodeType[])ArrayUtils.add((Object[])superTypes, (Object)nodeType) : (ExtendedNodeType[])ArrayUtils.addAll(allTypes, (Object[])ArrayUtils.add((Object[])superTypes, (Object)nodeType));
        }
        return allTypes;
    }

    private static void checkMissingChildrenOrProps(ExtendedNodeType[] allTypes, List<FieldDefinition> fields, List<String> missingChildren, List<String> missingProps) {
        fields.stream().filter(field -> {
            Directive fieldDirective = field.getDirective("mapping");
            return fieldDirective != null && fieldDirective.getArgument("property") != null;
        }).forEach(field -> {
            String propertyName;
            Directive fieldDirective = field.getDirective("mapping");
            String jcrPropertyName = ((StringValue)fieldDirective.getArgument("property").getValue()).getValue();
            if (!("path".equalsIgnoreCase(jcrPropertyName) || "identifier".equalsIgnoreCase(jcrPropertyName) || "url".equalsIgnoreCase(jcrPropertyName) || "fakeproperty".equalsIgnoreCase(jcrPropertyName) || SDLTypeChecker.hasChildren(allTypes, propertyName = StringUtils.substringBefore((String)jcrPropertyName, (String)".")) || SDLTypeChecker.hasProperty(allTypes, propertyName))) {
                missingChildren.add(jcrPropertyName);
            }
        });
    }

    private static SDLDefinitionStatus checkForInvalidFetcherDirective(SDLSchemaService sdlSchemaService, ObjectTypeDefinition objectTypeDefinition, FieldDefinition fieldDefinition) {
        Directive fetcherDirective = fieldDefinition.getDirective("fetcher");
        if (fetcherDirective != null) {
            Argument fetcherName = fetcherDirective.getArgument("name");
            if (fetcherName == null) {
                return new SDLDefinitionStatus(objectTypeDefinition.getName(), SDLDefinitionStatusType.MISSING_FETCHER_ARGUMENT, "name", fieldDefinition.getName());
            }
            if (fetcherName.getValue() != null && !sdlSchemaService.getPropertyFetcherExtensions().containsKey(((StringValue)fetcherName.getValue()).getValue())) {
                return new SDLDefinitionStatus(objectTypeDefinition.getName(), SDLDefinitionStatusType.MISSING_FETCHER, ((StringValue)fetcherName.getValue()).getValue());
            }
        }
        return new SDLDefinitionStatus(objectTypeDefinition.getName(), SDLDefinitionStatusType.OK);
    }
}

