/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.sdl.parsing;

import graphql.GraphQLException;
import graphql.Scalars;
import graphql.annotations.processor.GraphQLAnnotationsComponent;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.DirectiveDefinition;
import graphql.language.DirectiveLocation;
import graphql.language.FieldDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.ListType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectTypeExtensionDefinition;
import graphql.language.SDLDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.Value;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jahia.modules.graphql.provider.dxm.DXGraphQLExtensionsProvider;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldSorterInput;
import org.jahia.modules.graphql.provider.dxm.relay.DXRelay;
import org.jahia.modules.graphql.provider.dxm.sdl.SDLUtil;
import org.jahia.modules.graphql.provider.dxm.sdl.extension.FinderAdapter;
import org.jahia.modules.graphql.provider.dxm.sdl.extension.FinderMixinInterface;
import org.jahia.modules.graphql.provider.dxm.sdl.extension.PropertyFetcherExtensionInterface;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.Finder;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.FinderBaseDataFetcher;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.FinderFetchersFactory;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.FinderListDataFetcher;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.SDLPaginatedDataConnectionFetcher;
import org.jahia.modules.graphql.provider.dxm.sdl.parsing.ConnectionHelper;
import org.jahia.modules.graphql.provider.dxm.sdl.parsing.SDLRuntimeWiring;
import org.jahia.modules.graphql.provider.dxm.sdl.parsing.SDLTypeChecker;
import org.jahia.modules.graphql.provider.dxm.sdl.parsing.status.SDLDefinitionStatus;
import org.jahia.modules.graphql.provider.dxm.sdl.parsing.status.SDLDefinitionStatusType;
import org.jahia.modules.graphql.provider.dxm.sdl.parsing.status.SDLSchemaInfo;
import org.jahia.modules.graphql.provider.dxm.sdl.registration.SDLRegistrationService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SDLSchemaService.class}, immediate=true)
public class SDLSchemaService {
    private static Logger logger = LoggerFactory.getLogger(SDLSchemaService.class);
    private DXRelay relay;
    private GraphQLSchema graphQLSchema;
    private SDLRegistrationService sdlRegistrationService;
    private Map<String, List<SDLSchemaInfo>> bundlesSDLSchemaStatus = new TreeMap<String, List<SDLSchemaInfo>>();
    private Map<String, SDLDefinitionStatus> sdlDefinitionStatusMap = new TreeMap<String, SDLDefinitionStatus>();
    private Map<Object, GraphQLInputType> sdlSpecialInputTypes = new HashMap<Object, GraphQLInputType>();
    private List<FinderMixinInterface> finderMixins = new ArrayList<FinderMixinInterface>();
    private Map<String, PropertyFetcherExtensionInterface> propertyFetcherExtensions = new HashMap<String, PropertyFetcherExtensionInterface>();
    private Map<String, ConnectionHelper.ConnectionTypeInfo> connectionFieldNameToSDLType = new HashMap<String, ConnectionHelper.ConnectionTypeInfo>();
    private Map<String, GraphQLObjectType> edges = new HashMap<String, GraphQLObjectType>();
    private Map<String, GraphQLObjectType> connections = new HashMap<String, GraphQLObjectType>();

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policyOption=ReferencePolicyOption.GREEDY)
    public void setSdlRegistrationService(SDLRegistrationService sdlRegistrationService) {
        this.sdlRegistrationService = sdlRegistrationService;
    }

    public void generateSchema() {
        if (this.sdlRegistrationService != null && this.sdlRegistrationService.getSDLResources().size() > 0) {
            this.graphQLSchema = null;
            this.bundlesSDLSchemaStatus.clear();
            this.sdlDefinitionStatusMap.clear();
            TypeDefinitionRegistry typeDefinitionRegistry = this.prepareTypeRegistryDefinition();
            HashMap<TypeDefinition, String> sources = new HashMap<TypeDefinition, String>();
            this.parseResources(typeDefinitionRegistry, sources);
            HashSet invalidTypes = new HashSet();
            do {
                invalidTypes.clear();
                sources.forEach((type, bundle) -> {
                    SDLDefinitionStatus status = SDLTypeChecker.checkType(this, type, typeDefinitionRegistry);
                    this.sdlDefinitionStatusMap.put(type.getName(), status);
                    if (status.getStatus() != SDLDefinitionStatusType.OK) {
                        invalidTypes.add(type);
                        this.getOrCreateBundleSDLSchemaList((String)bundle).add(new SDLSchemaInfo((String)bundle, SDLSchemaInfo.SDLSchemaStatus.DEFINITION_ERROR, MessageFormat.format("Definition {0} : {1}", type.getName(), status.getStatusString())));
                    }
                });
                sources.keySet().removeAll(invalidTypes);
                invalidTypes.forEach(arg_0 -> ((TypeDefinitionRegistry)typeDefinitionRegistry).remove(arg_0));
            } while (!invalidTypes.isEmpty());
            SDLTypeChecker.printStatuses(this.sdlDefinitionStatusMap);
            SchemaGenerator schemaGenerator = new SchemaGenerator();
            TypeDefinitionRegistry cleanedTypeRegistry = new TypeDefinitionRegistry();
            typeDefinitionRegistry.types().forEach((k, t) -> cleanedTypeRegistry.add((SDLDefinition)t));
            typeDefinitionRegistry.objectTypeExtensions().forEach((k, t) -> t.forEach(e -> this.cleanObjectExtensions((ObjectTypeExtensionDefinition)e, sources, cleanedTypeRegistry)));
            typeDefinitionRegistry.scalars().forEach((k, t) -> cleanedTypeRegistry.add((SDLDefinition)t));
            typeDefinitionRegistry.getDirectiveDefinitions().forEach((k, t) -> cleanedTypeRegistry.add((SDLDefinition)t));
            try {
                this.graphQLSchema = schemaGenerator.makeExecutableSchema(SchemaGenerator.Options.defaultOptions().enforceSchemaDirectives(false), cleanedTypeRegistry, SDLRuntimeWiring.runtimeWiring());
            }
            catch (Exception e) {
                logger.warn("Invalid type definition(s) detected during schema generation {} ", (Object)e.getMessage());
            }
        }
    }

    private void cleanObjectExtensions(ObjectTypeExtensionDefinition e, Map<TypeDefinition, String> sources, TypeDefinitionRegistry cleanedTypeRegistry) {
        List fieldDefinitions = e.getFieldDefinitions().stream().filter(f -> {
            if (f.getName().endsWith("Connection") && (f.getName().contains(FinderFetchersFactory.FetcherType.PATH.getSuffix()) || f.getName().contains(FinderFetchersFactory.FetcherType.ID.getSuffix()))) {
                String bundleName = (String)sources.get(e);
                this.getOrCreateBundleSDLSchemaList(bundleName).add(new SDLSchemaInfo(bundleName, SDLSchemaInfo.SDLSchemaStatus.DEFINITION_ERROR, MessageFormat.format("You cannot use [{0}] as a query connection extension", f.getName())));
                logger.error("You cannot use [{}] as a query connection extension", (Object)f.getName());
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        e.getFieldDefinitions().removeAll(fieldDefinitions);
        if (!e.getFieldDefinitions().isEmpty()) {
            cleanedTypeRegistry.add((SDLDefinition)e);
        }
    }

    private void parseResources(TypeDefinitionRegistry typeDefinitionRegistry, Map<TypeDefinition, String> sources) {
        SchemaParser schemaParser = new SchemaParser();
        this.connections.clear();
        this.edges.clear();
        this.connectionFieldNameToSDLType.clear();
        for (Map.Entry<String, URL> entry : this.sdlRegistrationService.getSDLResources().entrySet()) {
            if (entry.getKey().equals("graphql-core")) continue;
            String bundle = entry.getKey();
            try {
                TypeDefinitionRegistry parsedRegistry = schemaParser.parse((Reader)new InputStreamReader(entry.getValue().openStream()));
                this.handleCustomConnectionTypes(parsedRegistry);
                parsedRegistry.types().forEach((key, type) -> sources.put((TypeDefinition)type, bundle));
                parsedRegistry.objectTypeExtensions().forEach((type, list) -> list.forEach(ext -> sources.put((TypeDefinition)ext, bundle)));
                typeDefinitionRegistry.merge(parsedRegistry);
                this.getOrCreateBundleSDLSchemaList(bundle);
            }
            catch (IOException ex) {
                logger.error("Failed to read sdl resource.", (Throwable)ex);
            }
            catch (GraphQLException ex) {
                logger.warn("Failed to merge schema from bundle [{}]: {}", (Object)bundle, (Object)ex.getMessage());
                this.getOrCreateBundleSDLSchemaList(bundle).add(new SDLSchemaInfo(bundle, SDLSchemaInfo.SDLSchemaStatus.SYNTAX_ERROR, ex.getMessage()));
            }
        }
    }

    public List<GraphQLFieldDefinition> getSDLQueries() {
        ArrayList<GraphQLFieldDefinition> defs = new ArrayList<GraphQLFieldDefinition>();
        if (this.graphQLSchema != null) {
            this.applyDefaultFetchers(defs);
            List fieldDefinitions = this.graphQLSchema.getQueryType().getFieldDefinitions();
            for (GraphQLFieldDefinition fieldDefinition : fieldDefinitions) {
                GraphQLObjectType objectType = fieldDefinition.getType() instanceof GraphQLList ? (GraphQLObjectType)((GraphQLList)fieldDefinition.getType()).getWrappedType() : (GraphQLObjectType)fieldDefinition.getType();
                GraphQLDirective directive = objectType.getDirective("mapping");
                if (directive == null) continue;
                String nodeType = directive.getArgument("node").getValue().toString();
                if (fieldDefinition.getName().contains("Connection")) {
                    String queryFieldName;
                    String typeName = queryFieldName = fieldDefinition.getName().replace("Connection", "");
                    if (this.connectionFieldNameToSDLType.containsKey(fieldDefinition.getName())) {
                        typeName = this.connectionFieldNameToSDLType.get(fieldDefinition.getName()).getConnectionName().replace("Connection", "");
                    }
                    GraphQLOutputType node = (GraphQLOutputType)((GraphQLList)fieldDefinition.getType()).getWrappedType();
                    GraphQLObjectType connectionType = ConnectionHelper.getOrCreateConnection(this, node, typeName);
                    FinderBaseDataFetcher typeFetcher = FinderFetchersFactory.getFetcher(fieldDefinition, nodeType);
                    List<GraphQLArgument> args = this.relay.getConnectionFieldArguments();
                    args.add(SDLUtil.wrapArgumentsInType(String.format("%s%s", queryFieldName, "Args"), typeFetcher.getArguments()));
                    SDLPaginatedDataConnectionFetcher fetcher = new SDLPaginatedDataConnectionFetcher((FinderListDataFetcher)typeFetcher);
                    GraphQLFieldDefinition sdlDef = GraphQLFieldDefinition.newFieldDefinition((GraphQLFieldDefinition)fieldDefinition).dataFetcher(fetcher).type((GraphQLOutputType)connectionType).argument(args).build();
                    defs.add(sdlDef);
                    continue;
                }
                FinderBaseDataFetcher fetcher = FinderFetchersFactory.getFetcher(fieldDefinition, nodeType);
                GraphQLFieldDefinition sdlDef = GraphQLFieldDefinition.newFieldDefinition((GraphQLFieldDefinition)fieldDefinition).dataFetcher((DataFetcher)fetcher).argument(fetcher.getArguments()).build();
                defs.add(sdlDef);
            }
        }
        return defs;
    }

    public List<GraphQLType> getSDLTypes() {
        ArrayList<GraphQLType> types = new ArrayList<GraphQLType>();
        if (this.graphQLSchema != null) {
            List<String> reservedType = Arrays.asList("Query", "Mutation", "Subscription");
            for (Map.Entry gqlTypeEntry : this.graphQLSchema.getTypeMap().entrySet()) {
                if (((String)gqlTypeEntry.getKey()).startsWith("__") || reservedType.contains(gqlTypeEntry.getKey()) || gqlTypeEntry.getValue() instanceof GraphQLScalarType) continue;
                types.add((GraphQLType)gqlTypeEntry.getValue());
            }
        }
        return types;
    }

    public GraphQLSchema getGraphQLSchema() {
        return this.graphQLSchema;
    }

    public Map<String, SDLDefinitionStatus> getSdlDefinitionStatusMap() {
        return this.sdlDefinitionStatusMap;
    }

    public Map<String, List<SDLSchemaInfo>> getBundlesSDLSchemaStatus() {
        return this.bundlesSDLSchemaStatus;
    }

    private List<SDLSchemaInfo> getOrCreateBundleSDLSchemaList(String bundle) {
        if (!this.bundlesSDLSchemaStatus.containsKey(bundle)) {
            this.bundlesSDLSchemaStatus.put(bundle, new LinkedList());
        }
        return this.bundlesSDLSchemaStatus.get(bundle);
    }

    private void applyDefaultFetchers(List<GraphQLFieldDefinition> defs) {
        for (GraphQLType type : this.graphQLSchema.getAllTypesAsList()) {
            GraphQLDirective directive;
            if (!(type instanceof GraphQLObjectType) || (directive = ((GraphQLObjectType)type).getDirective("mapping")) == null) continue;
            this.applyDefaultFetcher(defs, directive, (GraphQLOutputType)type, FinderFetchersFactory.FetcherType.ID);
            this.applyDefaultFetcher(defs, directive, (GraphQLOutputType)type, FinderFetchersFactory.FetcherType.PATH);
        }
    }

    private void applyDefaultFetcher(List<GraphQLFieldDefinition> defs, GraphQLDirective directive, GraphQLOutputType type, FinderFetchersFactory.FetcherType defaultFinder) {
        boolean shouldIgnoreDefaultQueries = false;
        if (directive.getArgument("ignoreDefaultQueries").getValue() != null) {
            shouldIgnoreDefaultQueries = (Boolean)directive.getArgument("ignoreDefaultQueries").getValue();
        }
        if (!shouldIgnoreDefaultQueries) {
            GraphQLArgument argument;
            GraphQLOutputType baseType = type;
            if (type instanceof GraphQLList) {
                baseType = (GraphQLOutputType)((GraphQLList)type).getWrappedType();
            }
            if ((argument = ((GraphQLObjectType)baseType).getDirective("mapping").getArgument("node")) != null) {
                String finderName = defaultFinder.getName(baseType.getName());
                Finder finder = new Finder(finderName);
                finder.setType(argument.getValue().toString());
                ArrayList<GraphQLArgument> args = new ArrayList<GraphQLArgument>();
                FinderBaseDataFetcher dataFetcher = FinderFetchersFactory.getFetcherType(finder, defaultFinder);
                args.addAll(dataFetcher.getArguments());
                ArrayList<FinderMixinInterface> applicableMixins = new ArrayList<FinderMixinInterface>();
                for (FinderMixinInterface finderMixin : this.finderMixins) {
                    if (!finderMixin.applyOnFinder(finder)) continue;
                    applicableMixins.add(finderMixin);
                    args.addAll(finderMixin.getArguments());
                }
                defs.add(GraphQLFieldDefinition.newFieldDefinition().name(finderName).description("default finder for " + finderName).dataFetcher((DataFetcher)new FinderAdapter(dataFetcher, applicableMixins)).argument(args).type(type).build());
            }
        }
    }

    private TypeDefinitionRegistry prepareTypeRegistryDefinition() {
        TypeDefinitionRegistry typeDefinitionRegistry = new TypeDefinitionRegistry();
        typeDefinitionRegistry.add((SDLDefinition)new ObjectTypeDefinition("Query"));
        typeDefinitionRegistry.add((SDLDefinition)new ScalarTypeDefinition("Date"));
        typeDefinitionRegistry.add((SDLDefinition)DirectiveDefinition.newDirectiveDefinition().name("mapping").directiveLocations(Arrays.asList(DirectiveLocation.newDirectiveLocation().name("OBJECT").build(), DirectiveLocation.newDirectiveLocation().name("FIELD_DEFINITION").build())).inputValueDefinitions(Arrays.asList(InputValueDefinition.newInputValueDefinition().name("node").type((Type)TypeName.newTypeName((String)Scalars.GraphQLString.getName()).build()).build(), InputValueDefinition.newInputValueDefinition().name("property").type((Type)TypeName.newTypeName((String)Scalars.GraphQLString.getName()).build()).build(), InputValueDefinition.newInputValueDefinition().name("ignoreDefaultQueries").type((Type)TypeName.newTypeName((String)Scalars.GraphQLBoolean.getName()).build()).build())).build());
        typeDefinitionRegistry.add((SDLDefinition)DirectiveDefinition.newDirectiveDefinition().name("fetcher").directiveLocations(Arrays.asList(DirectiveLocation.newDirectiveLocation().name("FIELD_DEFINITION").build())).inputValueDefinitions(Arrays.asList(InputValueDefinition.newInputValueDefinition().name("name").type((Type)TypeName.newTypeName((String)Scalars.GraphQLString.getName()).build()).build())).build());
        return typeDefinitionRegistry;
    }

    private void handleCustomConnectionTypes(TypeDefinitionRegistry typeDefinitionRegistry) {
        String type;
        String connectionName;
        int queryIndex = 0;
        if (typeDefinitionRegistry.objectTypeExtensions().containsKey("Query")) {
            ObjectTypeExtensionDefinition query = (ObjectTypeExtensionDefinition)((List)typeDefinitionRegistry.objectTypeExtensions().get("Query")).get(queryIndex);
            List fields = query.getFieldDefinitions();
            for (FieldDefinition f : fields) {
                if (!f.getName().endsWith("Connection") || !(f.getType() instanceof TypeName)) continue;
                connectionName = ((TypeName)f.getType()).getName();
                type = connectionName.replace("Connection", "");
                this.connectionFieldNameToSDLType.put(f.getName(), new ConnectionHelper.ConnectionTypeInfo(type, connectionName));
            }
            if (!this.connectionFieldNameToSDLType.isEmpty()) {
                ObjectTypeExtensionDefinition newQuery = ConnectionHelper.newQueryWithoutConnections(query, this.connectionFieldNameToSDLType);
                newQuery = newQuery.transformExtension((Consumer)new ConnectionHelper.TransformQueryExtension(this.connectionFieldNameToSDLType));
                ((List)typeDefinitionRegistry.objectTypeExtensions().get("Query")).remove(queryIndex);
                typeDefinitionRegistry.add((SDLDefinition)newQuery);
            }
        }
        for (ObjectTypeDefinition objectType : typeDefinitionRegistry.getTypes(ObjectTypeDefinition.class)) {
            Iterator fields = objectType.getFieldDefinitions().iterator();
            while (fields.hasNext()) {
                FieldDefinition field = (FieldDefinition)fields.next();
                if (!(field.getType() instanceof TypeName) || !((TypeName)field.getType()).getName().endsWith("Connection")) continue;
                fields.remove();
                connectionName = ((TypeName)field.getType()).getName();
                type = connectionName.replace("Connection", "");
                this.connectionFieldNameToSDLType.put(objectType.getName() + "." + field.getName(), new ConnectionHelper.ConnectionTypeInfo(type, connectionName));
            }
            for (Map.Entry<String, ConnectionHelper.ConnectionTypeInfo> entry : this.connectionFieldNameToSDLType.entrySet()) {
                if (!entry.getKey().startsWith(objectType.getName() + ".")) continue;
                String name = StringUtils.substringAfter((String)entry.getKey(), (String)".");
                objectType.getFieldDefinitions().add(FieldDefinition.newFieldDefinition().directive(Directive.newDirective().name("mapping").arguments(Arrays.asList(Argument.newArgument().name("property").value((Value)new StringValue("fakeproperty")).build())).build()).name(name).type((Type)new ListType((Type)TypeName.newTypeName((String)entry.getValue().getMappedToType()).build())).build());
            }
        }
    }

    public void setRelay(DXRelay relay) {
        this.relay = relay;
    }

    public void refreshSpecialInputTypes(GraphQLAnnotationsComponent graphQLAnnotations, ProcessingElementsContainer container) {
        this.sdlSpecialInputTypes.clear();
        for (SpecialInputTypes specialInputType : SpecialInputTypes.values()) {
            this.sdlSpecialInputTypes.put(specialInputType.name, graphQLAnnotations.getInputTypeProcessor().getInputTypeOrRef(specialInputType.klass, container));
        }
    }

    public GraphQLInputType getSDLSpecialInputType(String name) {
        return this.sdlSpecialInputTypes.get(name);
    }

    public void addExtensions(DXGraphQLExtensionsProvider extensionsProvider) {
        this.addFinderMixins(extensionsProvider.getFinderMixins());
        this.addPropertyFetcherExtensions(extensionsProvider.getPropertyFetchers());
    }

    public void clearExtensions() {
        this.clearFinderMixins();
        this.clearPropertyFetcherExtensions();
    }

    public Map<String, PropertyFetcherExtensionInterface> getPropertyFetcherExtensions() {
        return this.propertyFetcherExtensions;
    }

    public Map<String, ConnectionHelper.ConnectionTypeInfo> getConnectionFieldNameToSDLType() {
        return this.connectionFieldNameToSDLType;
    }

    public Map<String, GraphQLObjectType> getEdges() {
        return this.edges;
    }

    public Map<String, GraphQLObjectType> getConnections() {
        return this.connections;
    }

    public DXRelay getRelay() {
        return this.relay;
    }

    private void addFinderMixins(List<FinderMixinInterface> mixins) {
        this.finderMixins.addAll(mixins);
    }

    private void clearFinderMixins() {
        this.finderMixins.clear();
    }

    private void addPropertyFetcherExtensions(Map<String, PropertyFetcherExtensionInterface> propertyFetcherExtensions) {
        this.propertyFetcherExtensions.putAll(propertyFetcherExtensions);
    }

    private void clearPropertyFetcherExtensions() {
        this.propertyFetcherExtensions.clear();
    }

    public static enum SpecialInputTypes {
        FIELD_SORTER_INPUT("FieldSorterInput", FieldSorterInput.class);

        private String name;
        private Class klass;

        private SpecialInputTypes(String name, Class klass) {
            this.name = name;
            this.klass = klass;
        }

        public String getName() {
            return this.name;
        }

        public Class getKlass() {
            return this.klass;
        }
    }
}

