/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.sdl.parsing;

import graphql.language.FieldDefinition;
import graphql.language.ListType;
import graphql.language.ObjectTypeExtensionDefinition;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jahia.modules.graphql.provider.dxm.sdl.parsing.SDLSchemaService;

public class ConnectionHelper {
    public static ObjectTypeExtensionDefinition newQueryWithoutConnections(ObjectTypeExtensionDefinition oldQuery, Map<String, ConnectionTypeInfo> connectionFieldNameToSDLType) {
        ObjectTypeExtensionDefinition.Builder query = ObjectTypeExtensionDefinition.newObjectTypeExtensionDefinition().name("Query");
        query.name(oldQuery.getName());
        query.comments(oldQuery.getComments());
        query.description(oldQuery.getDescription());
        query.directives(oldQuery.getDirectives());
        query.implementz(oldQuery.getImplements());
        query.sourceLocation(oldQuery.getSourceLocation());
        query.fieldDefinitions(oldQuery.getFieldDefinitions().stream().filter(f -> !connectionFieldNameToSDLType.containsKey(f.getName())).collect(Collectors.toList()));
        return query.build();
    }

    public static GraphQLObjectType getOrCreateConnection(SDLSchemaService service, GraphQLOutputType node, String typeName) {
        GraphQLObjectType connectionType;
        Map<String, GraphQLObjectType> edges = service.getEdges();
        Map<String, GraphQLObjectType> connections = service.getConnections();
        GraphQLObjectType edge = edges.get(node.getName());
        if (edge == null) {
            edge = service.getRelay().edgeType(node.getName(), node, null, Collections.emptyList());
            edges.put(node.getName(), edge);
        }
        if ((connectionType = connections.get(typeName)) == null) {
            connectionType = service.getRelay().connectionType(typeName, edge, Collections.emptyList());
            connections.put(typeName, connectionType);
        }
        return connectionType;
    }

    public static class TransformQueryExtension
    implements Consumer<ObjectTypeExtensionDefinition.Builder> {
        private Map<String, ConnectionTypeInfo> connectionFieldNameToSDLType;

        public TransformQueryExtension(Map<String, ConnectionTypeInfo> connectionFieldNameToSDLType) {
            this.connectionFieldNameToSDLType = connectionFieldNameToSDLType;
        }

        @Override
        public void accept(ObjectTypeExtensionDefinition.Builder builder) {
            for (Map.Entry<String, ConnectionTypeInfo> entry : this.connectionFieldNameToSDLType.entrySet()) {
                builder.fieldDefinition(FieldDefinition.newFieldDefinition().name(entry.getKey()).type((Type)new ListType((Type)TypeName.newTypeName((String)entry.getValue().getMappedToType()).build())).build());
            }
        }
    }

    public static class ConnectionTypeInfo {
        private String mappedToType;
        private String connectionName;

        public ConnectionTypeInfo(String mappedToType, String connectionName) {
            this.mappedToType = mappedToType;
            this.connectionName = connectionName;
        }

        public String getMappedToType() {
            return this.mappedToType;
        }

        public String getConnectionName() {
            return this.connectionName;
        }
    }
}

