/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.sdl.monitor;

import java.io.File;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jahia.modules.external.modules.osgi.ModulesSourceMonitor;
import org.jahia.modules.graphql.provider.dxm.DXGraphQLProvider;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDLFileSourceMonitor
implements ModulesSourceMonitor {
    private static Logger logger = LoggerFactory.getLogger(SDLFileSourceMonitor.class);
    private BundleContext bundleContext;
    private ComponentContext componentContext;

    public SDLFileSourceMonitor(BundleContext bundleContext, ComponentContext componentContext) {
        this.bundleContext = bundleContext;
        this.componentContext = componentContext;
    }

    public boolean canHandleFileType(FileObject filePath) {
        try {
            FileObject parent = filePath.getParent();
            if (parent != null) {
                String baseName = filePath.getName().getBaseName();
                String parentName = parent.getName().getBaseName();
                if (baseName.equals("graphql-extension.sdl") && parentName.equals("META-INF")) {
                    logger.info("We can handle file {}", (Object)baseName);
                    return true;
                }
            }
        }
        catch (FileSystemException e) {
            logger.error("Cannot read file", (Throwable)e);
        }
        return false;
    }

    public void handleFile(File file) {
        logger.debug("Processing file {}", (Object)file);
        this.componentContext.disableComponent(DXGraphQLProvider.class.getName());
        this.componentContext.enableComponent(DXGraphQLProvider.class.getName());
    }
}

