/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.sdl.fetchers;

import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.Field;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.ListDataFetcher;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.ObjectDataFetcher;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.PropertiesDataFetcher;

public class PropertiesDataFetcherFactory {
    private PropertiesDataFetcherFactory() {
    }

    public static DataFetcher getFetcher(GraphQLFieldDefinition graphQLFieldDefinition, Field field) {
        String propertyValue;
        GraphQLDirective mapping = graphQLFieldDefinition.getDirective("mapping");
        GraphQLArgument property = mapping != null ? mapping.getArgument("property") : null;
        String string = propertyValue = property != null ? property.getValue().toString() : null;
        if ("identifier".equals(propertyValue)) {
            return environment -> {
                GqlJcrNode node = (GqlJcrNode)environment.getSource();
                return node.getUuid();
            };
        }
        if ("path".equals(propertyValue)) {
            return environment -> {
                GqlJcrNode node = (GqlJcrNode)environment.getSource();
                return node.getPath();
            };
        }
        if ("url".equals(propertyValue)) {
            return environment -> {
                GqlJcrNode node = (GqlJcrNode)environment.getSource();
                return node.getNode().getUrl();
            };
        }
        if (graphQLFieldDefinition.getType() instanceof GraphQLObjectType) {
            return new ObjectDataFetcher(field);
        }
        if (graphQLFieldDefinition.getType() instanceof GraphQLList) {
            return new ListDataFetcher(field);
        }
        return new PropertiesDataFetcher(field);
    }
}

