/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.sdl.fetchers;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNodeImpl;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.Field;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRPropertyWrapperImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectDataFetcher
implements DataFetcher<Object> {
    private static Logger logger = LoggerFactory.getLogger(ObjectDataFetcher.class);
    private Field field;

    public ObjectDataFetcher(Field field) {
        this.field = field;
    }

    public Object get(DataFetchingEnvironment environment) throws Exception {
        GqlJcrNode node = (GqlJcrNode)environment.getSource();
        JCRNodeWrapper jcrNode = node.getNode();
        try {
            if (jcrNode.hasNode(this.field.getProperty())) {
                logger.debug("Fetch child {}", (Object)this.field.getType());
                JCRNodeWrapper subNode = jcrNode.getNode(this.field.getProperty());
                return new GqlJcrNodeImpl(subNode);
            }
            logger.debug("Fetch reference {}", (Object)this.field.getType());
            JCRPropertyWrapper propertyNode = jcrNode.getProperty(this.field.getProperty());
            return new GqlJcrNodeImpl(((JCRPropertyWrapperImpl)propertyNode).getReferencedNode());
        }
        catch (RepositoryException e) {
            return null;
        }
    }
}

