/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.sdl.fetchers;

import graphql.Scalars;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLScalarType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.node.SpecializedTypesHandler;
import org.jahia.modules.graphql.provider.dxm.sdl.SDLUtil;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.FinderListDataFetcher;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.NumberFinder;
import org.jahia.modules.graphql.provider.dxm.security.PermissionHelper;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import pl.touk.throwing.ThrowingFunction;

public class NumberFinderDataFetcher
extends FinderListDataFetcher {
    private static final String GT = "gt";
    private static final String GTE = "gte";
    private static final String LT = "lt";
    private static final String LTE = "lte";
    private static final String EQ = "eq";
    private static final String NOTEQ = "noteq";

    public NumberFinderDataFetcher(NumberFinder finder) {
        super(finder.getType(), finder);
    }

    @Override
    public List<GraphQLArgument> getArguments() {
        List<GraphQLArgument> list = this.getDefaultArguments();
        list.add(GraphQLArgument.newArgument().name(GT).type((GraphQLInputType)this.getGraphQLScalarType(((NumberFinder)this.finder).getNumberType())).description("Property greater than passed parameter").build());
        list.add(GraphQLArgument.newArgument().name(GTE).type((GraphQLInputType)this.getGraphQLScalarType(((NumberFinder)this.finder).getNumberType())).description("Property greater than or equal to passed parameter").build());
        list.add(GraphQLArgument.newArgument().name(LT).type((GraphQLInputType)this.getGraphQLScalarType(((NumberFinder)this.finder).getNumberType())).description("Property less than passed parameter").build());
        list.add(GraphQLArgument.newArgument().name(LTE).type((GraphQLInputType)this.getGraphQLScalarType(((NumberFinder)this.finder).getNumberType())).description("Property less than or equal to passed parameter").build());
        list.add(GraphQLArgument.newArgument().name(EQ).type((GraphQLInputType)this.getGraphQLScalarType(((NumberFinder)this.finder).getNumberType())).description("Property equal to passed parameter").build());
        list.add(GraphQLArgument.newArgument().name(NOTEQ).type((GraphQLInputType)this.getGraphQLScalarType(((NumberFinder)this.finder).getNumberType())).description("Property not equal to passed parameter").build());
        return list;
    }

    @Override
    public List<GqlJcrNode> get(DataFetchingEnvironment environment) {
        return this.getStream(environment).collect(Collectors.toList());
    }

    @Override
    public Stream<GqlJcrNode> getStream(DataFetchingEnvironment environment) {
        try {
            String statement = "SELECT * FROM [%s] as n where n.[%s]%s%s";
            Map<String, Object> arguments = SDLUtil.getArguments(environment);
            String comparisonParameterName = this.firstValidParameter(arguments);
            if (comparisonParameterName == null) {
                throw new DataFetchingException(String.format("Entry point %s must have of on comparison parameter, look at the documentation for available parameter names.", environment.getFieldDefinition().getName()));
            }
            switch (comparisonParameterName) {
                case "lt": {
                    statement = String.format(statement, this.type, this.finder.getProperty(), "<", arguments.get(comparisonParameterName));
                    break;
                }
                case "lte": {
                    statement = String.format(statement, this.type, this.finder.getProperty(), "<=", arguments.get(comparisonParameterName));
                    break;
                }
                case "gt": {
                    statement = String.format(statement, this.type, this.finder.getProperty(), ">", arguments.get(comparisonParameterName));
                    break;
                }
                case "gte": {
                    statement = String.format(statement, this.type, this.finder.getProperty(), ">=", arguments.get(comparisonParameterName));
                    break;
                }
                case "eq": {
                    statement = String.format(statement, this.type, this.finder.getProperty(), "=", arguments.get(comparisonParameterName));
                    break;
                }
                case "noteq": {
                    statement = String.format(statement, this.type, this.finder.getProperty(), "<>", arguments.get(comparisonParameterName));
                    break;
                }
            }
            JCRSessionWrapper currentUserSession = NumberFinderDataFetcher.getCurrentUserSession(environment);
            JCRNodeIteratorWrapper it = currentUserSession.getWorkspace().getQueryManager().createQuery(statement, "JCR-SQL2").execute().getNodes();
            Stream<GqlJcrNode> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false).filter(node -> PermissionHelper.hasPermission(node, environment)).map(ThrowingFunction.unchecked(SpecializedTypesHandler::getNode));
            return this.resolveCollection(stream, environment);
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    private String firstValidParameter(Map<String, Object> arguments) {
        Set<Map.Entry<String, Object>> args = arguments.entrySet();
        Optional<Map.Entry> argEntry = args.stream().filter(arg -> ((String)arg.getKey()).equals(GT) || ((String)arg.getKey()).equals(GTE) || ((String)arg.getKey()).equals(LT) || ((String)arg.getKey()).equals(LTE) || ((String)arg.getKey()).equals(EQ) || ((String)arg.getKey()).equals(NOTEQ)).findFirst();
        return argEntry.isPresent() ? (String)argEntry.get().getKey() : null;
    }

    private GraphQLScalarType getGraphQLScalarType(String name) {
        switch (name) {
            case "Int": {
                return Scalars.GraphQLInt;
            }
            case "Long": {
                return Scalars.GraphQLLong;
            }
            case "BigInteger": {
                return Scalars.GraphQLBigInteger;
            }
            case "BigDecimal": {
                return Scalars.GraphQLBigDecimal;
            }
            case "Float": {
                return Scalars.GraphQLFloat;
            }
            case "Short": {
                return Scalars.GraphQLShort;
            }
        }
        return Scalars.GraphQLInt;
    }
}

