/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.sdl.fetchers;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLInputType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.sdl.SDLUtil;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.Finder;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.LanguageCodeConverters;

public abstract class FinderBaseDataFetcher
implements DataFetcher {
    protected static final String PREVIEW = "preview";
    protected static final String LANGUAGE = "language";
    protected String type;
    protected Finder finder;

    public FinderBaseDataFetcher(String type, Finder finder) {
        this.type = type.split(",")[0];
        this.finder = finder;
    }

    public FinderBaseDataFetcher(String type) {
        this(type, null);
    }

    protected static Locale getLocale(DataFetchingEnvironment environment) {
        String language = (String)SDLUtil.getArgument(LANGUAGE, environment);
        if (language == null) {
            return SettingsBean.getInstance().getDefaultLocale();
        }
        return LanguageCodeConverters.languageCodeToLocale((String)language);
    }

    protected static JCRSessionWrapper getCurrentUserSession(DataFetchingEnvironment environment) throws RepositoryException {
        return FinderBaseDataFetcher.getCurrentUserSession(environment, FinderBaseDataFetcher.getLocale(environment));
    }

    protected static JCRSessionWrapper getCurrentUserSession(DataFetchingEnvironment environment, Locale locale) throws RepositoryException {
        Boolean preview = (Boolean)SDLUtil.getArgument(PREVIEW, environment);
        if (preview == null) {
            preview = Boolean.FALSE;
        }
        return JCRSessionFactory.getInstance().getCurrentUserSession(preview != false ? "default" : "live", locale);
    }

    protected List<GraphQLArgument> getDefaultArguments() {
        ArrayList<GraphQLArgument> list = new ArrayList<GraphQLArgument>();
        list.add(GraphQLArgument.newArgument().name(PREVIEW).type((GraphQLInputType)Scalars.GraphQLBoolean).description("Return content from live or default workspace").defaultValue((Object)false).build());
        list.add(GraphQLArgument.newArgument().name(LANGUAGE).type((GraphQLInputType)Scalars.GraphQLString).description("Content language, defaults to English").defaultValue((Object)"en").build());
        return list;
    }

    public List<GraphQLArgument> getArguments() {
        return this.getDefaultArguments();
    }

    public abstract Object get(DataFetchingEnvironment var1);
}

