/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.sdl.fetchers;

import graphql.Scalars;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLInputType;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.node.SpecializedTypesHandler;
import org.jahia.modules.graphql.provider.dxm.sdl.SDLUtil;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.Finder;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.FinderListDataFetcher;
import org.jahia.modules.graphql.provider.dxm.sdl.validation.ArgumentValidator;
import org.jahia.modules.graphql.provider.dxm.security.PermissionHelper;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import pl.touk.throwing.ThrowingFunction;

public class DateRangeDataFetcher
extends FinderListDataFetcher {
    private static final String ARG_AFTER = "after";
    private static final String ARG_BEFORE = "before";
    private static final String ARG_LASTDAYS = "lastDays";

    public DateRangeDataFetcher(Finder finder) {
        super(finder.getType(), finder);
    }

    @Override
    public List<GraphQLArgument> getArguments() {
        List<GraphQLArgument> args = this.getDefaultArguments();
        args.add(GraphQLArgument.newArgument().name(ARG_AFTER).type((GraphQLInputType)Scalars.GraphQLString).description("Select content after date").build());
        args.add(GraphQLArgument.newArgument().name(ARG_BEFORE).type((GraphQLInputType)Scalars.GraphQLString).description("Select content before date").build());
        args.add(GraphQLArgument.newArgument().name(ARG_LASTDAYS).type((GraphQLInputType)Scalars.GraphQLInt).description("Select content within last days").build());
        return args;
    }

    @Override
    public List<GqlJcrNode> get(DataFetchingEnvironment environment) {
        if (!ArgumentValidator.validate(ArgumentValidator.ArgumentNames.DATE_RANGE, environment) || !ArgumentValidator.validate(ArgumentValidator.ArgumentNames.SORT_BY, environment)) {
            return Collections.emptyList();
        }
        return this.getStream(environment).collect(Collectors.toList());
    }

    @Override
    public Stream<GqlJcrNode> getStream(DataFetchingEnvironment environment) {
        if (!ArgumentValidator.validate(ArgumentValidator.ArgumentNames.DATE_RANGE, environment) || !ArgumentValidator.validate(ArgumentValidator.ArgumentNames.SORT_BY, environment)) {
            return Stream.empty();
        }
        try {
            String statement = this.buildSQL2Statement(environment);
            JCRSessionWrapper currentUserSession = DateRangeDataFetcher.getCurrentUserSession(environment);
            JCRNodeIteratorWrapper it = currentUserSession.getWorkspace().getQueryManager().createQuery(statement, "JCR-SQL2").execute().getNodes();
            Stream<GqlJcrNode> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false).filter(node -> PermissionHelper.hasPermission(node, environment)).map(ThrowingFunction.unchecked(SpecializedTypesHandler::getNode));
            return this.resolveCollection(stream, environment);
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    private String buildSQL2Statement(DataFetchingEnvironment environment) {
        String after = (String)SDLUtil.getArgument(ARG_AFTER, environment);
        String before = (String)SDLUtil.getArgument(ARG_BEFORE, environment);
        Integer lastDays = (Integer)SDLUtil.getArgument(ARG_LASTDAYS, environment);
        if (lastDays != null) {
            Date afterDate = DateUtils.addDays((Date)new Date(), (int)(-lastDays.intValue()));
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSSXXX");
            after = dateFormat.format(afterDate);
        }
        SQL2DateTypeQuery sql2 = new SQL2DateTypeQuery();
        sql2.selectFrom(this.type).where().and(sql2.constrain(">=", this.finder.getProperty(), sql2.castDate(after)), sql2.constrain("<=", this.finder.getProperty(), sql2.castDate(before)));
        return sql2.getStatement();
    }

    private class SQL2DateTypeQuery {
        public static final String SPACE = " ";
        public static final String START_WITH_SPACE = " * ";
        public static final String OPERATOR_GTE = ">=";
        public static final String OPERATOR_LTE = "<=";
        final StringBuilder sb = new StringBuilder();

        SQL2DateTypeQuery() {
        }

        public SQL2DateTypeQuery selectFrom(String type) {
            this.sb.append("SELECT * FROM [\"" + type + "\"]");
            return this;
        }

        public SQL2DateTypeQuery where() {
            this.sb.append(SPACE);
            this.sb.append("WHERE");
            return this;
        }

        public SQL2DateTypeQuery and(String ... constrains) {
            List trimedConstrains = Arrays.stream(constrains).filter(Objects::nonNull).collect(Collectors.toList());
            this.sb.append(SPACE);
            for (int i = 0; i < trimedConstrains.size(); ++i) {
                if (StringUtils.isBlank((String)((String)trimedConstrains.get(i)))) continue;
                if (i > 0) {
                    this.sb.append(" AND ");
                }
                this.sb.append((String)trimedConstrains.get(i));
            }
            return this;
        }

        public String constrain(String operator, String property, String value) {
            return StringUtils.isBlank((String)value) ? null : "[" + property + "]" + SPACE + operator + SPACE + value;
        }

        public String castDate(String value) {
            return StringUtils.isBlank((String)value) ? null : "CAST('" + value + "' AS DATE)";
        }

        public String getStatement() {
            return this.sb.toString();
        }
    }
}

