/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.sdl.fetchers;

import graphql.Scalars;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLInputType;
import java.util.Collections;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.node.SpecializedTypesHandler;
import org.jahia.modules.graphql.provider.dxm.sdl.SDLUtil;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.Finder;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.FinderListDataFetcher;
import org.jahia.modules.graphql.provider.dxm.sdl.validation.ArgumentValidator;
import org.jahia.modules.graphql.provider.dxm.security.PermissionHelper;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import pl.touk.throwing.ThrowingFunction;

public class BooleanFinderDataFetcher
extends FinderListDataFetcher {
    private static final String VALUE = "value";

    BooleanFinderDataFetcher(Finder finder) {
        super(finder.getType(), finder);
    }

    @Override
    public List<GraphQLArgument> getArguments() {
        List<GraphQLArgument> list = this.getDefaultArguments();
        list.add(GraphQLArgument.newArgument().name(VALUE).description("select content if boolean value true or false").type((GraphQLInputType)Scalars.GraphQLBoolean).defaultValue((Object)true).build());
        return list;
    }

    @Override
    public List<GqlJcrNode> get(DataFetchingEnvironment environment) {
        if (!ArgumentValidator.validate(ArgumentValidator.ArgumentNames.VALUE, environment) || !ArgumentValidator.validate(ArgumentValidator.ArgumentNames.SORT_BY, environment)) {
            return Collections.emptyList();
        }
        return this.getStream(environment).collect(Collectors.toList());
    }

    @Override
    public Stream<GqlJcrNode> getStream(DataFetchingEnvironment environment) {
        if (!ArgumentValidator.validate(ArgumentValidator.ArgumentNames.VALUE, environment) || !ArgumentValidator.validate(ArgumentValidator.ArgumentNames.SORT_BY, environment)) {
            return Stream.empty();
        }
        try {
            String statement = this.buildSQL2Statement(environment);
            JCRSessionWrapper currentUserSession = BooleanFinderDataFetcher.getCurrentUserSession(environment);
            JCRNodeIteratorWrapper it = currentUserSession.getWorkspace().getQueryManager().createQuery(statement, "JCR-SQL2").execute().getNodes();
            Stream<GqlJcrNode> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false).filter(node -> PermissionHelper.hasPermission(node, environment)).map(ThrowingFunction.unchecked(SpecializedTypesHandler::getNode));
            return this.resolveCollection(stream, environment);
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    private String buildSQL2Statement(DataFetchingEnvironment environment) {
        Boolean value = (Boolean)SDLUtil.getArgument(VALUE, environment);
        return "SELECT * FROM [" + this.type + "] WHERE [" + this.finder.getProperty() + "] = " + value;
    }
}

