/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.sdl;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SDLUtil {
    private SDLUtil() {
    }

    public static GraphQLArgument wrapArgumentsInType(String typeName, List<GraphQLArgument> args) {
        GraphQLInputObjectType.Builder newObject = GraphQLInputObjectType.newInputObject();
        GraphQLInputObjectType.Builder defaultObject = GraphQLInputObjectType.newInputObject();
        args.forEach(arg -> {
            newObject.name(String.format("%s%s", typeName, "Input")).field(GraphQLInputObjectField.newInputObjectField().name(arg.getName()).description(arg.getDescription()).type(arg.getType()).defaultValue(arg.getDefaultValue()).build());
            if (arg.getDefaultValue() != null) {
                defaultObject.name(String.format("%s%s", typeName, "Input")).field(GraphQLInputObjectField.newInputObjectField().name(arg.getName()).description(arg.getDescription()).type(arg.getType()).defaultValue(arg.getDefaultValue()).build());
            }
        });
        return GraphQLArgument.newArgument().name(typeName).description("Available arguments").type((GraphQLInputType)newObject.build()).defaultValue((Object)defaultObject.build()).build();
    }

    public static Object getArgument(String argName, DataFetchingEnvironment environment) {
        Map args = environment.getArguments();
        if (environment.getFieldDefinition().getName().endsWith("Connection")) {
            String name = environment.getFieldDefinition().getName().replace("Connection", "Args");
            Object argObject = args.get(name);
            if (argObject instanceof GraphQLInputObjectType) {
                GraphQLInputObjectField field = ((GraphQLInputObjectType)argObject).getField(argName);
                return field != null ? field.getDefaultValue() : null;
            }
            return ((Map)args.get(name)).get(argName);
        }
        return args.get(argName);
    }

    public static Map<String, Object> getArguments(DataFetchingEnvironment environment) {
        Map args = environment.getArguments();
        if (environment.getFieldDefinition().getName().endsWith("Connection")) {
            String name = environment.getFieldDefinition().getName().replace("Connection", "Args");
            Object argObject = args.get(name);
            if (argObject instanceof GraphQLInputObjectType) {
                return ((GraphQLInputObjectType)argObject).getFields().stream().collect(Collectors.toMap(GraphQLInputObjectField::getName, GraphQLInputObjectField::getDefaultValue));
            }
            return (Map)args.get(name);
        }
        return args;
    }

    public static int getArgumentsSize(DataFetchingEnvironment environment) {
        Map args = environment.getArguments();
        if (environment.getFieldDefinition().getName().endsWith("Connection")) {
            String name = environment.getFieldDefinition().getName().replace("Connection", "Args");
            Object argObject = args.get(name);
            if (argObject instanceof GraphQLInputObjectType) {
                return ((GraphQLInputObjectType)argObject).getFields().size();
            }
            return ((Map)args.get(name)).size();
        }
        return args.size();
    }

    public static Boolean isFieldInWrappedTypeFields(String fieldName, DataFetchingEnvironment environment) {
        GraphQLList list = environment.getFieldDefinition().getType() instanceof GraphQLObjectType ? (GraphQLList)((GraphQLObjectType)environment.getFieldDefinition().getType()).getFieldDefinition("nodes").getType() : (GraphQLList)environment.getFieldDefinition().getType();
        GraphQLObjectType type = (GraphQLObjectType)list.getWrappedType();
        GraphQLFieldDefinition fieldDefinition = SDLUtil.getFieldDefinition(fieldName, type);
        return fieldDefinition != null;
    }

    private static GraphQLFieldDefinition getFieldDefinition(String fieldName, GraphQLObjectType type) {
        String[] nameParts;
        GraphQLFieldDefinition fieldDefinition = null;
        for (String part : nameParts = fieldName.split("\\.")) {
            GraphQLFieldDefinition fieldDef = type.getFieldDefinition(part);
            if (fieldDef == null) {
                return null;
            }
            GraphQLOutputType f = fieldDef.getType();
            if (f instanceof GraphQLObjectType) {
                type = (GraphQLObjectType)f;
                continue;
            }
            fieldDefinition = type.getFieldDefinition(part);
        }
        return fieldDefinition;
    }
}

