/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.scheduler;

import graphql.annotations.annotationTypes.GraphQLDefaultValue;
import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jahia.modules.graphql.provider.dxm.DXGraphQLProvider;
import org.jahia.modules.graphql.provider.dxm.scheduler.GqlBackgroundJob;
import org.jahia.modules.graphql.provider.dxm.scheduler.GqlJobListener;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.scheduler.SchedulerService;
import org.quartz.JobListener;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GraphQLTypeExtension(value=DXGraphQLProvider.Subscription.class)
public class GqlJobSubscriptionExtension {
    static Logger logger = LoggerFactory.getLogger(GqlJobSubscriptionExtension.class);

    @GraphQLField
    @GraphQLDescription(value="Subscription on background jobs")
    public static Publisher<GqlBackgroundJob> backgroundJobSubscription(@GraphQLName(value="targetScheduler") @GraphQLDefaultValue(value=TargetSchedulerDefaultValue.class) @GraphQLDescription(value="The target scheduler for listening jobs") TargetScheduler targetScheduler, @GraphQLName(value="filterByGroups") @GraphQLDescription(value="Subscribe only to job with matching group names") List<String> groupsFilter, @GraphQLName(value="filterByNames") @GraphQLDescription(value="Subscribe only to job with matching names") List<String> namesFilter, @GraphQLName(value="filterByJobStatuses") @GraphQLDescription(value="Subscribe only to job with matching job statuses") List<GqlBackgroundJob.GqlBackgroundJobStatus> jobStatusesFilter, @GraphQLName(value="filterByJobStates") @GraphQLDescription(value="Subscribe only to job with matching job states") List<GqlBackgroundJob.GqlBackgroundJobState> jobStatesFilter) {
        boolean ramScheduler = targetScheduler == TargetScheduler.RAM_SCHEDULER || targetScheduler == TargetScheduler.BOTH;
        boolean scheduler = targetScheduler == TargetScheduler.SCHEDULER || targetScheduler == TargetScheduler.BOTH;
        Predicate<GqlBackgroundJob> jobFilter = gqlBackgroundJob -> !(groupsFilter != null && !groupsFilter.contains(gqlBackgroundJob.getGroup()) || namesFilter != null && !namesFilter.contains(gqlBackgroundJob.getName()) || jobStatusesFilter != null && !jobStatusesFilter.contains((Object)gqlBackgroundJob.getJobStatus()) || jobStatesFilter != null && !jobStatesFilter.contains((Object)gqlBackgroundJob.getJobState()));
        return Flowable.create(obs -> {
            SchedulerService schedulerService = ServicesRegistry.getInstance().getSchedulerService();
            String name = UUID.randomUUID().toString();
            GqlJobListener jobListener = new GqlJobListener(name, (FlowableEmitter<GqlBackgroundJob>)obs, jobFilter);
            if (ramScheduler) {
                logger.info("Adding job listener {} for RAM scheduler", (Object)name);
                schedulerService.addJobListener((JobListener)jobListener, true);
            }
            if (scheduler) {
                logger.info("Adding job listener {}", (Object)name);
                schedulerService.addJobListener((JobListener)jobListener, false);
            }
            obs.setCancellable(() -> {
                if (ramScheduler) {
                    schedulerService.removeJobListener(name, true);
                }
                if (scheduler) {
                    schedulerService.removeJobListener(name, false);
                }
            });
        }, (BackpressureStrategy)BackpressureStrategy.BUFFER);
    }

    public static class TargetSchedulerDefaultValue
    implements Supplier<Object> {
        @Override
        public TargetScheduler get() {
            return TargetScheduler.BOTH;
        }
    }

    @GraphQLDescription(value="The target scheduler(s)")
    public static enum TargetScheduler {
        SCHEDULER,
        RAM_SCHEDULER,
        BOTH;

    }
}

