/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.scheduler;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import org.quartz.JobDetail;

@GraphQLDescription(value="Background job")
public class GqlBackgroundJob {
    private JobDetail jobDetail;
    private GqlBackgroundJobStatus jobStatus;
    private GqlBackgroundJobState jobState;

    public GqlBackgroundJob(JobDetail jobDetail, GqlBackgroundJobState state) {
        this.jobDetail = jobDetail;
        this.jobStatus = GqlBackgroundJobStatus.valueOf(jobDetail.getJobDataMap().getString("status").toUpperCase());
        this.jobState = state;
    }

    @GraphQLField
    @GraphQLName(value="name")
    @GraphQLDescription(value="The job name")
    public String getName() {
        return this.jobDetail.getName();
    }

    @GraphQLField
    @GraphQLName(value="group")
    @GraphQLDescription(value="The job group name")
    public String getGroup() {
        return this.jobDetail.getGroup();
    }

    @GraphQLField
    @GraphQLName(value="jobStatus")
    @GraphQLDescription(value="The job status")
    public GqlBackgroundJobStatus getJobStatus() {
        return this.jobStatus;
    }

    @GraphQLField
    @GraphQLName(value="jobState")
    @GraphQLDescription(value="The job state is different from the status, it reflect the last action done on the job instance (Started, Vetoed, Finished)")
    public GqlBackgroundJobState getJobState() {
        return this.jobState;
    }

    @GraphQLField
    @GraphQLName(value="duration")
    @GraphQLDescription(value="The amount of time the job ran for (in milliseconds). The returned value will be -1 until the job has actually completed")
    public Long getDuration() {
        if (this.jobDetail.getJobDataMap().containsKey((Object)"duration")) {
            return this.jobDetail.getJobDataMap().getLongFromString("duration");
        }
        return -1L;
    }

    @GraphQLField
    @GraphQLName(value="userKey")
    @GraphQLDescription(value="The user key. The returned value will be null in case the job doesn't have associated user key")
    public String getUserKey() {
        if (this.jobDetail.getJobDataMap().containsKey((Object)"userkey")) {
            return this.jobDetail.getJobDataMap().getString("userkey");
        }
        return null;
    }

    @GraphQLField
    @GraphQLName(value="siteKey")
    @GraphQLDescription(value="The site key. The returned value will be null in case the job doesn't have associated site key")
    public String getSiteKey() {
        if (this.jobDetail.getJobDataMap().containsKey((Object)"sitekey")) {
            return this.jobDetail.getJobDataMap().getString("sitekey");
        }
        return null;
    }

    @GraphQLField
    @GraphQLName(value="jobStringProperty")
    @GraphQLDescription(value="The job (String) property that correspond to the given name. The returned value will be null in case the job doesn't have the property")
    public String getJobStringProperty(@GraphQLName(value="name") @GraphQLDescription(value="The job name") String name) {
        if (this.jobDetail.getJobDataMap().containsKey((Object)name)) {
            return this.jobDetail.getJobDataMap().getString(name);
        }
        return null;
    }

    @GraphQLField
    @GraphQLName(value="jobLongProperty")
    @GraphQLDescription(value="The job (Long) property that correspond to the given name. The returned value will be null in case the job doesn't have the property")
    public Long getJobLongProperty(@GraphQLName(value="name") @GraphQLDescription(value="The job name") String name) {
        if (this.jobDetail.getJobDataMap().containsKey((Object)name)) {
            return this.jobDetail.getJobDataMap().getLongValue(name);
        }
        return null;
    }

    @GraphQLField
    @GraphQLName(value="jobIntegerProperty")
    @GraphQLDescription(value="The job (Int) property that correspond to the given name. The returned value will be null in case the job doesn't have the property")
    public Integer getJobIntegerProperty(@GraphQLName(value="name") @GraphQLDescription(value="The job name") String name) {
        if (this.jobDetail.getJobDataMap().containsKey((Object)name)) {
            return this.jobDetail.getJobDataMap().getIntValue(name);
        }
        return null;
    }

    @GraphQLField
    @GraphQLName(value="jobBooleanProperty")
    @GraphQLDescription(value="The job (Boolean) property that correspond to the given name. The returned value will be null in case the job doesn't have the property")
    public Boolean getJobBooleanProperty(@GraphQLName(value="name") @GraphQLDescription(value="The job name") String name) {
        if (this.jobDetail.getJobDataMap().containsKey((Object)name)) {
            return this.jobDetail.getJobDataMap().getBoolean(name);
        }
        return null;
    }

    public static enum GqlBackgroundJobState {
        STARTED,
        VETOED,
        FINISHED;

    }

    public static enum GqlBackgroundJobStatus {
        ADDED,
        SCHEDULED,
        EXECUTING,
        SUCCESSFUL,
        FAILED,
        CANCELED;

    }
}

