/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.publication;

import graphql.annotations.annotationTypes.GraphQLName;
import java.util.HashMap;
import java.util.Map;

@GraphQLName(value="PublicationStatus")
public enum GqlPublicationStatus {
    PUBLISHED(1),
    MODIFIED(3),
    NOT_PUBLISHED(4),
    UNPUBLISHED(5),
    MANDATORY_LANGUAGE_UNPUBLISHABLE(6),
    LIVE_MODIFIED(7),
    LIVE_ONLY(8),
    CONFLICT(9),
    MANDATORY_LANGUAGE_VALID(10),
    DELETED(11),
    MARKED_FOR_DELETION(12);

    private static final Map<Integer, GqlPublicationStatus> PUBLICATION_STATUS_BY_STATUS_VALUE;
    private int statusValue;

    private GqlPublicationStatus(int statusValue) {
        this.statusValue = statusValue;
    }

    public static GqlPublicationStatus fromStatusValue(int statusValue) throws IllegalArgumentException {
        if (PUBLICATION_STATUS_BY_STATUS_VALUE.containsKey(statusValue)) {
            return PUBLICATION_STATUS_BY_STATUS_VALUE.get(statusValue);
        }
        throw new IllegalArgumentException("Unknown publication status value: " + statusValue);
    }

    static {
        PUBLICATION_STATUS_BY_STATUS_VALUE = new HashMap<Integer, GqlPublicationStatus>();
        for (GqlPublicationStatus publicationStatus : GqlPublicationStatus.values()) {
            PUBLICATION_STATUS_BY_STATUS_VALUE.put(publicationStatus.statusValue, publicationStatus);
        }
    }
}

