/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.predicate;

import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldEvaluator;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldSorterInput;

public class SorterHelper {
    private static final Map<SortType, FieldSorterAlgorithm> SORT_BY_DIRECTION = new EnumMap<SortType, FieldSorterAlgorithm>(SortType.class);

    public static Comparator<Object> getFieldComparator(FieldSorterInput sortFilter, FieldEvaluator environment) {
        FieldSorterAlgorithm sorterAlgorithm;
        SortType sortType = sortFilter.getSortType();
        if (sortType == null) {
            sortType = SortType.ASC;
        }
        if ((sorterAlgorithm = SORT_BY_DIRECTION.get((Object)sortType)) == null) {
            throw new IllegalArgumentException("Unknown sort direction : " + (Object)((Object)sortType));
        }
        return (object, obj) -> sorterAlgorithm.evaluate(object, sortFilter.getFieldName(), environment.getFieldValue(obj, sortFilter.getFieldName()), sortFilter.isIgnoreCase() == null || sortFilter.isIgnoreCase() != false, environment);
    }

    static {
        FieldSorterAlgorithm fieldSorterAlgorithm = (source, fieldName, fieldValue, ignoreCase, environment) -> {
            Object value = environment.getFieldValue(source, fieldName);
            if (value == null && fieldValue == null) {
                return 0;
            }
            if (value == null) {
                return -1;
            }
            if (fieldValue == null) {
                return 1;
            }
            if (fieldValue instanceof Boolean) {
                return Boolean.compare((Boolean)value, (Boolean)fieldValue);
            }
            if (fieldValue instanceof Long) {
                return Long.compare((Long)value, (Long)fieldValue);
            }
            if (fieldValue instanceof Double) {
                return Double.compare((Double)value, (Double)fieldValue);
            }
            if (fieldValue instanceof Integer) {
                return Integer.compare((Integer)value, (Integer)fieldValue);
            }
            if (fieldValue instanceof String) {
                return ignoreCase ? ((String)value).compareToIgnoreCase((String)fieldValue) : ((String)value).compareTo((String)fieldValue);
            }
            if (fieldValue instanceof Enum) {
                return value.toString().compareTo(fieldValue.toString());
            }
            return 0;
        };
        SORT_BY_DIRECTION.put(SortType.ASC, fieldSorterAlgorithm);
        SORT_BY_DIRECTION.put(SortType.DESC, (source, fieldName, fieldValue, ignoreCase, environment) -> -fieldSorterAlgorithm.evaluate(source, fieldName, fieldValue, ignoreCase, environment));
    }

    @FunctionalInterface
    static interface FieldSorterAlgorithm {
        public int evaluate(Object var1, String var2, Object var3, boolean var4, FieldEvaluator var5);
    }

    public static enum SortType {
        ASC,
        DESC;

    }
}

