/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.predicate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldEvaluator;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldGroupingInput;

public class GroupingHelper {
    private static final String UNGROUPED_LIST = "theRest";

    public static <T> Stream<T> group(Stream<T> stream, FieldGroupingInput fieldGroupingInput, FieldEvaluator fieldEvaluator) {
        List originalList = stream.collect(Collectors.toList());
        LinkedHashMap buckets = new LinkedHashMap();
        buckets.put(UNGROUPED_LIST, new ArrayList());
        for (String group : fieldGroupingInput.getGroups()) {
            buckets.put(group, new ArrayList());
        }
        for (String node : originalList) {
            String groupByFieldValue = (String)fieldEvaluator.getFieldValue(node, fieldGroupingInput.getFieldName());
            if (buckets.containsKey(groupByFieldValue)) {
                ((List)buckets.get(groupByFieldValue)).add(node);
                continue;
            }
            ((List)buckets.get(UNGROUPED_LIST)).add(node);
        }
        ArrayList groupedList = new ArrayList();
        for (Map.Entry entry : buckets.entrySet()) {
            if (((String)entry.getKey()).equals(UNGROUPED_LIST)) continue;
            groupedList.addAll((Collection)entry.getValue());
        }
        if (fieldGroupingInput.getGroupingType().equals((Object)GroupingType.END)) {
            ((List)buckets.get(UNGROUPED_LIST)).addAll(groupedList);
            return ((List)buckets.get(UNGROUPED_LIST)).stream();
        }
        if (fieldGroupingInput.getGroupingType().equals((Object)GroupingType.START)) {
            groupedList.addAll((Collection)buckets.get(UNGROUPED_LIST));
            return groupedList.stream();
        }
        return originalList.stream();
    }

    public static enum GroupingType {
        END,
        START;

    }
}

