/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.osgiconfig;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.osgi.annotations.GraphQLOsgiService;
import org.jahia.modules.graphql.provider.dxm.osgiconfig.GqlConfigurationProperty;
import org.jahia.modules.graphql.provider.dxm.osgiconfig.GqlValueQuery;
import org.jahia.services.modulemanager.spi.Config;
import org.jahia.services.modulemanager.spi.ConfigService;
import org.jahia.services.modulemanager.util.PropertiesValues;

@GraphQLDescription(value="Query for OSGi configuration")
public class GqlConfigurationQuery
extends GqlValueQuery {
    private final String pid;
    private final String identifier;
    @Inject
    @GraphQLOsgiService
    private ConfigService configService;
    private Config configuration = null;

    public GqlConfigurationQuery(String pid, String identifier) {
        super(null);
        this.pid = pid;
        this.identifier = identifier;
    }

    @Override
    protected PropertiesValues getPropertiesValues() {
        if (this.propertiesValues == null) {
            this.propertiesValues = this.getConfiguration().getValues();
        }
        return super.getPropertiesValues();
    }

    @GraphQLField
    @GraphQLDescription(value="Get all properties of the configuration, as they are stored in OSGi")
    public List<GqlConfigurationProperty> getFlatProperties() {
        return this.getConfiguration().getRawProperties().entrySet().stream().map(entry -> new GqlConfigurationProperty((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
    }

    @GraphQLField
    @GraphQLDescription(value="Get all properties of the configuration, as they are stored in OSGi")
    public Set<String> getFlatKeys() {
        return this.getConfiguration().getRawProperties().keySet();
    }

    private Config getConfiguration() {
        try {
            this.configuration = this.identifier == null ? this.configService.getConfig(this.pid) : this.configService.getConfig(this.pid, this.identifier);
        }
        catch (IOException e) {
            throw new DataFetchingException(e);
        }
        return this.configuration;
    }
}

