/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.osgiconfig;

import graphql.annotations.annotationTypes.GraphQLDescription;
import java.io.IOException;
import javax.inject.Inject;
import org.jahia.modules.graphql.provider.dxm.DXGraphQLFieldCompleter;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.osgi.annotations.GraphQLOsgiService;
import org.jahia.modules.graphql.provider.dxm.osgiconfig.GqlValueMutation;
import org.jahia.services.modulemanager.spi.Config;
import org.jahia.services.modulemanager.spi.ConfigService;
import org.jahia.services.modulemanager.util.PropertiesValues;

@GraphQLDescription(value="Mutation for OSGi configuration")
public class GqlConfigurationMutation
extends GqlValueMutation
implements DXGraphQLFieldCompleter {
    private final String pid;
    private final String identifier;
    @Inject
    @GraphQLOsgiService
    private ConfigService configService;
    private Config configuration = null;

    public GqlConfigurationMutation(String pid, String identifier) {
        super(null);
        this.pid = pid;
        this.identifier = identifier;
    }

    @Override
    protected PropertiesValues getPropertiesValues() {
        if (this.propertiesValues == null) {
            this.propertiesValues = this.getConfiguration().getValues();
        }
        return super.getPropertiesValues();
    }

    private Config getConfiguration() {
        try {
            this.configuration = this.identifier == null ? this.configService.getConfig(this.pid) : this.configService.getConfig(this.pid, this.identifier);
        }
        catch (IOException e) {
            throw new DataFetchingException(e);
        }
        return this.configuration;
    }

    @Override
    public void completeField() {
        if (this.configuration != null) {
            try {
                this.configService.storeConfig(this.configuration);
            }
            catch (IOException e) {
                throw new DataFetchingException(e);
            }
        }
    }
}

