/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.nodetype;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrProperty;
import org.jahia.modules.graphql.provider.dxm.nodetype.GqlJcrPropertyDefinition;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;

@GraphQLTypeExtension(value=GqlJcrProperty.class)
@GraphQLDescription(value="Extensions for JCRProperty")
public class NodetypeJCRPropertyExtensions {
    private GqlJcrProperty property;

    public NodetypeJCRPropertyExtensions(GqlJcrProperty property) {
        this.property = property;
    }

    @GraphQLField
    @GraphQLName(value="definition")
    @GraphQLDescription(value="Returns the property definition that applies to this property.")
    public GqlJcrPropertyDefinition getDefinition() {
        ExtendedPropertyDefinition definition;
        try {
            definition = (ExtendedPropertyDefinition)this.property.getProperty().getDefinition();
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        if (definition != null) {
            return new GqlJcrPropertyDefinition(definition);
        }
        return null;
    }
}

