/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.nodetype;

import com.google.common.base.Splitter;
import graphql.annotations.annotationTypes.GraphQLDefaultValue;
import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import graphql.schema.DataFetchingEnvironment;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeTypeIterator;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.node.NodeHelper;
import org.jahia.modules.graphql.provider.dxm.nodetype.GqlJcrNodeDefinition;
import org.jahia.modules.graphql.provider.dxm.nodetype.GqlJcrNodeType;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldEvaluator;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldFiltersInput;
import org.jahia.modules.graphql.provider.dxm.predicate.FilterHelper;
import org.jahia.modules.graphql.provider.dxm.util.GqlUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.nodetypes.ConstraintsHelper;
import org.jahia.services.content.nodetypes.ExtendedNodeDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;

@GraphQLTypeExtension(value=GqlJcrNode.class)
@GraphQLDescription(value="Extensions for JCRNode")
public class NodetypeJCRNodeExtensions {
    private GqlJcrNode node;

    public NodetypeJCRNodeExtensions(GqlJcrNode node) {
        this.node = node;
    }

    private static void collectSubTypes(Collection<ExtendedNodeType> result, ExtendedNodeType type) {
        NodeTypeIterator it = type.getSubtypes();
        while (it.hasNext()) {
            ExtendedNodeType subType = (ExtendedNodeType)it.next();
            result.add(subType);
            NodetypeJCRNodeExtensions.collectSubTypes(result, subType);
        }
    }

    @GraphQLField
    @GraphQLName(value="primaryNodeType")
    @GraphQLDescription(value="Get the primary node type of this node")
    @GraphQLNonNull
    public GqlJcrNodeType getPrimaryNodeType() {
        try {
            return new GqlJcrNodeType(this.node.getNode().getPrimaryNodeType());
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="isNodeType")
    @GraphQLDescription(value="Reports if the current node matches the nodetype(s) passed in parameter")
    @GraphQLNonNull
    public boolean isNodeType(@GraphQLName(value="type") @GraphQLDescription(value="Node type name") @GraphQLNonNull GqlJcrNode.NodeTypesInput input) {
        return NodeHelper.getTypesPredicate(input).test(this.node.getNode());
    }

    @GraphQLField
    @GraphQLName(value="mixinTypes")
    @GraphQLDescription(value="Returns an array of <code>NodeType</code> objects representing the mixin node types in effect for this node.")
    @GraphQLNonNull
    public List<GqlJcrNodeType> getMixinTypes(@GraphQLName(value="fieldFilter") @GraphQLDescription(value="Filter by GraphQL fields values") FieldFiltersInput fieldFilter, DataFetchingEnvironment environment) {
        try {
            return Arrays.stream(this.node.getNode().getMixinNodeTypes()).map(GqlJcrNodeType::new).filter(FilterHelper.getFieldPredicate(fieldFilter, FieldEvaluator.forList(environment))).collect(Collectors.toList());
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="definition")
    @GraphQLDescription(value="Returns the node definition that applies to this node.")
    public GqlJcrNodeDefinition getDefinition() {
        ExtendedNodeDefinition definition;
        try {
            definition = this.node.getNode().getDefinition();
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        if (definition != null) {
            return new GqlJcrNodeDefinition(definition);
        }
        return null;
    }

    @GraphQLField
    @GraphQLName(value="allowedChildNodeTypes")
    @GraphQLDescription(value="Returns a list of types allowed under the provided node")
    public List<GqlJcrNodeType> getAllowedChildNodeTypes(@GraphQLName(value="includeSubTypes") @GraphQLDescription(value="Whether all sub-types of allowed child node types should be included") @GraphQLDefaultValue(value=GqlUtils.SupplierTrue.class) boolean includeSubTypes, @GraphQLName(value="fieldFilter") @GraphQLDescription(value="Filter by GraphQL fields values") FieldFiltersInput fieldFilter, DataFetchingEnvironment environment) {
        String constraints;
        try {
            constraints = ConstraintsHelper.getConstraints((JCRNodeWrapper)this.node.getNode());
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        if (constraints.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashSet<ExtendedNodeType> types = new LinkedHashSet<ExtendedNodeType>();
        List typeNames = Splitter.on((String)" ").splitToList((CharSequence)constraints);
        for (String typeName : typeNames) {
            ExtendedNodeType type;
            try {
                type = NodeTypeRegistry.getInstance().getNodeType(typeName);
            }
            catch (NoSuchNodeTypeException e) {
                throw new RuntimeException(e);
            }
            types.add(type);
            if (!includeSubTypes) continue;
            NodetypeJCRNodeExtensions.collectSubTypes(types, type);
        }
        return types.stream().map(GqlJcrNodeType::new).filter(FilterHelper.getFieldPredicate(fieldFilter, FieldEvaluator.forList(environment))).collect(Collectors.toList());
    }
}

