/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.nodetype;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.spi.commons.nodetype.constraint.ValueConstraint;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrPropertyType;
import org.jahia.modules.graphql.provider.dxm.nodetype.GqlJcrItemDefinition;
import org.jahia.modules.graphql.provider.dxm.nodetype.GqlJcrNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;

@GraphQLName(value="JCRPropertyDefinition")
@GraphQLDescription(value="GraphQL representation of a JCR property definition")
public class GqlJcrPropertyDefinition
implements GqlJcrItemDefinition {
    private ExtendedPropertyDefinition definition;

    public GqlJcrPropertyDefinition(ExtendedPropertyDefinition definition) {
        this.definition = definition;
    }

    @Override
    @GraphQLName(value="name")
    @GraphQLNonNull
    @GraphQLDescription(value="Gets the name of the child item.")
    public String getName() {
        return this.definition.getName();
    }

    @Override
    @GraphQLNonNull
    @GraphQLDescription(value="Reports whether the item is mandatory. A mandatory item is one that, if its parent node exists, must also exist.")
    public boolean isMandatory() {
        return this.definition.isMandatory();
    }

    @Override
    @GraphQLNonNull
    @GraphQLDescription(value="Reports whether the item is to be automatically created when its parent node is created.")
    public boolean isAutoCreated() {
        return this.definition.isAutoCreated();
    }

    @Override
    @GraphQLNonNull
    @GraphQLDescription(value="Reports whether the child item is protected.")
    public boolean isProtected() {
        return this.definition.isProtected();
    }

    @Override
    @GraphQLNonNull
    @GraphQLDescription(value="Reports whether the child item is hidden from UI.")
    public boolean isHidden() {
        return this.definition.isHidden();
    }

    @GraphQLNonNull
    @GraphQLField
    @GraphQLDescription(value="Property constraints")
    public List<String> getConstraints() {
        return Arrays.stream(this.definition.getValueConstraintObjects()).map(ValueConstraint::getString).collect(Collectors.toList());
    }

    @Override
    @GraphQLName(value="declaringNodeType")
    @GraphQLNonNull
    @GraphQLDescription(value="Gets the node type that contains the declaration of this definition.")
    public GqlJcrNodeType getDeclaringNodeType() {
        return new GqlJcrNodeType(this.definition.getDeclaringNodeType());
    }

    @GraphQLField
    @GraphQLName(value="internationalized")
    @GraphQLDescription(value="Reports whether this property has language dependant values.")
    @GraphQLNonNull
    public boolean isInternationalized() {
        return this.definition.isInternationalized();
    }

    @GraphQLField
    @GraphQLDescription(value="Reports whether this property can have multiple values.")
    @GraphQLNonNull
    public boolean isMultiple() {
        return this.definition.isMultiple();
    }

    @GraphQLField
    @GraphQLName(value="requiredType")
    @GraphQLDescription(value="Gets the required type of the property.")
    @GraphQLNonNull
    public GqlJcrPropertyType getRequiredType() {
        return GqlJcrPropertyType.fromValue(this.definition.getRequiredType());
    }

    @GraphQLField
    @GraphQLName(value="displayName")
    @GraphQLDescription(value="Gets the displayable name of the property for the given language code. Return the system name in case the label doesn't exists")
    @GraphQLNonNull
    public String getDisplayName(@GraphQLName(value="language") @GraphQLDescription(value="Language") @GraphQLNonNull String language) {
        String displayName = this.definition.getLabel(new Locale(language));
        return StringUtils.isNotEmpty((String)displayName) ? displayName : this.getName();
    }
}

