/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.node;

import graphql.TypeResolutionEnvironment;
import graphql.annotations.processor.GraphQLAnnotationsComponent;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.TypeResolver;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNodeImpl;
import org.jahia.modules.graphql.provider.dxm.node.NodeHelper;
import org.jahia.services.content.JCRNodeWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecializedTypesHandler {
    private GraphQLAnnotationsComponent graphQLAnnotations;
    private ProcessingElementsContainer container;
    private static Logger logger = LoggerFactory.getLogger(SpecializedTypesHandler.class);
    private Map<String, Class<? extends GqlJcrNode>> specializedTypesClass = new HashMap<String, Class<? extends GqlJcrNode>>();
    private Map<String, GraphQLObjectType> knownTypes = new ConcurrentHashMap<String, GraphQLObjectType>();
    private static SpecializedTypesHandler instance;

    public static SpecializedTypesHandler getInstance() {
        return instance;
    }

    public SpecializedTypesHandler(GraphQLAnnotationsComponent annotations, ProcessingElementsContainer container) {
        instance = this;
        this.graphQLAnnotations = annotations;
        this.container = container;
    }

    public void addType(String nodeType, Class<? extends GqlJcrNode> clazz) {
        this.specializedTypesClass.put(nodeType, clazz);
        logger.debug("Registered specialized type {} handled by class {}", (Object)nodeType, clazz);
    }

    public Map<String, GraphQLObjectType> getKnownTypes() {
        return this.knownTypes;
    }

    public void initializeTypes() {
        this.knownTypes = new HashMap<String, GraphQLObjectType>();
        GraphQLInterfaceType interfaceType = (GraphQLInterfaceType)this.graphQLAnnotations.getOutputTypeProcessor().getOutputTypeOrRef(GqlJcrNode.class, this.container);
        for (Map.Entry<String, Class<? extends GqlJcrNode>> entry : this.specializedTypesClass.entrySet()) {
            this.knownTypes.put(entry.getKey(), (GraphQLObjectType)this.graphQLAnnotations.getOutputTypeProcessor().getOutputTypeOrRef(entry.getValue(), this.container));
        }
    }

    public static GqlJcrNode getNode(JCRNodeWrapper node) throws RepositoryException {
        return SpecializedTypesHandler.getNode(node, node.getPrimaryNodeTypeName());
    }

    public static GqlJcrNode getNode(JCRNodeWrapper node, String type) throws RepositoryException {
        if (!NodeHelper.checkNodeValidity(node = NodeHelper.getNodeInLanguage(node, null))) {
            throw new ItemNotFoundException(node.getIdentifier());
        }
        if (SpecializedTypesHandler.getInstance().specializedTypesClass.containsKey(type)) {
            try {
                return SpecializedTypesHandler.getInstance().specializedTypesClass.get(type).getConstructor(JCRNodeWrapper.class).newInstance(node);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        return new GqlJcrNodeImpl(node, type);
    }

    public static class NodeTypeResolver
    implements TypeResolver {
        public GraphQLObjectType getType(TypeResolutionEnvironment env) {
            String type = ((GqlJcrNode)env.getObject()).getType();
            SpecializedTypesHandler instance = SpecializedTypesHandler.getInstance();
            if (instance.knownTypes.containsKey(type)) {
                return (GraphQLObjectType)instance.knownTypes.get(type);
            }
            return (GraphQLObjectType)instance.graphQLAnnotations.getOutputTypeProcessor().getOutputTypeOrRef(GqlJcrNodeImpl.class, instance.container);
        }
    }
}

