/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.node;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrMutation;
import org.jahia.modules.graphql.provider.dxm.util.ZipUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;

@GraphQLName(value="ZipFileMutation")
public class GqlZipMutation {
    private JCRNodeWrapper file;

    public GqlZipMutation(JCRNodeWrapper file) {
        this.file = file;
    }

    @GraphQLField
    @GraphQLDescription(value="zip a file")
    public boolean addToZip(@GraphQLName(value="pathsOrIds") @GraphQLNonNull @GraphQLDescription(value="list of paths or ids to zip") List<String> pathsOrIds, DataFetchingEnvironment environment) throws DataFetchingException {
        ArrayList<JCRNodeWrapper> nodes = new ArrayList<JCRNodeWrapper>();
        for (String pathOrId : pathsOrIds) {
            try {
                JCRNodeWrapper node = GqlJcrMutation.getNodeFromPathOrId(JCRSessionFactory.getInstance().getCurrentUserSession("default"), pathOrId);
                if (!node.isNodeType("jnt:file") && !node.isNodeType("jnt:folder")) {
                    throw new DataFetchingException(node.getName() + " is neither a file nor a folder");
                }
                nodes.add(node);
            }
            catch (RepositoryException e) {
                throw new DataFetchingException(e);
            }
        }
        ZipUtils.addToZip(nodes, this.file);
        return true;
    }

    @GraphQLField
    @GraphQLDescription(value="unzip a zip file")
    public boolean unzip(@GraphQLName(value="path") @GraphQLNonNull @GraphQLDescription(value="destination path to unzip") String path, DataFetchingEnvironment environment) throws DataFetchingException {
        try {
            JCRNodeWrapper destinationNode;
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default");
            if (session.nodeExists(path)) {
                destinationNode = GqlJcrMutation.getNodeFromPathOrId(session, path);
                if (!destinationNode.isNodeType("jnt:folder")) {
                    throw new DataFetchingException(path + " is not a folder");
                }
            } else {
                throw new DataFetchingException(path + " this path does not exist");
            }
            ZipUtils.unzip(destinationNode, this.file);
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
        return true;
    }
}

