/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.node;

import graphql.annotations.annotationTypes.GraphQLDefaultValue;
import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.connection.GraphQLConnection;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.function.Supplier;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.Source;
import org.apache.commons.lang.LocaleUtils;
import org.jahia.modules.graphql.provider.dxm.BaseGqlClientException;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.GqlConstraintHandler;
import org.jahia.modules.graphql.provider.dxm.JahiaDataFetchingExceptionHandler;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNodeCriteriaInput;
import org.jahia.modules.graphql.provider.dxm.node.NodeHelper;
import org.jahia.modules.graphql.provider.dxm.node.NodeQueryExtensions;
import org.jahia.modules.graphql.provider.dxm.node.SpecializedTypesHandler;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldFiltersInput;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldGroupingInput;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldSorterInput;
import org.jahia.modules.graphql.provider.dxm.relay.DXPaginatedData;
import org.jahia.modules.graphql.provider.dxm.relay.DXPaginatedDataConnectionFetcher;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.query.QueryWrapper;
import pl.touk.throwing.exception.WrappedException;

@GraphQLName(value="JCRQuery")
@GraphQLDescription(value="JCR Queries")
public class GqlJcrQuery {
    private NodeQueryExtensions.Workspace workspace;

    public GqlJcrQuery(NodeQueryExtensions.Workspace workspace) {
        this.workspace = workspace;
    }

    @GraphQLField
    @GraphQLName(value="workspace")
    @GraphQLNonNull
    @GraphQLDescription(value="Get the workspace of the query")
    public NodeQueryExtensions.Workspace getWorkspace() {
        return this.workspace;
    }

    @GraphQLField
    @GraphQLName(value="nodeById")
    @GraphQLDescription(value="Get GraphQL representation of a node by its UUID")
    public GqlJcrNode getNodeById(@GraphQLName(value="uuid") @GraphQLNonNull @GraphQLDescription(value="The UUID of the node") String uuid, @GraphQLName(value="validInLanguage") @GraphQLDescription(value="Check node validity in this language. \n\n Node validity is determined by multiple conditions: \n\n * The node exists \n * The node is not attached to a visibility condition preventing its display \n * The node is published in this language \n * The node's language has not been invalidated.") String validInLanguage) {
        try {
            return this.getGqlNodeById(uuid, validInLanguage);
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="nodeByPath")
    @GraphQLDescription(value="Get GraphQL representation of a node by its path")
    public GqlJcrNode getNodeByPath(@GraphQLName(value="path") @GraphQLNonNull @GraphQLDescription(value="The path of the node") String path, @GraphQLName(value="validInLanguage") @GraphQLDescription(value="Check node validity in this language. \n\n Node validity is determined by multiple conditions: \n\n * The node exists \n * The node is not attached to a visibility condition preventing its display \n * The node is published in this language \n * The node's language has not been invalidated.") String validInLanguage) {
        try {
            return this.getGqlNodeByPath(path, validInLanguage);
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLNonNull
    @GraphQLName(value="nodesById")
    @GraphQLDescription(value="Get GraphQL representations of multiple nodes by their UUIDs")
    public DataFetcherResult<Collection<GqlJcrNode>> getNodesById(@GraphQLName(value="uuids") @GraphQLNonNull @GraphQLDescription(value="The UUIDs of the nodes") @GraphQLNonNull Collection<@GraphQLNonNull String> uuids, @GraphQLName(value="validInLanguage") @GraphQLDescription(value="Check node validity in this language. \n\n Node validity is determined by multiple conditions: \n\n * The node exists \n * The node is not attached to a visibility condition preventing its display \n * The node is published in this language \n * The node's language has not been invalidated.") String validInLanguage, DataFetchingEnvironment environment) {
        ArrayList<GqlJcrNode> nodes = new ArrayList<GqlJcrNode>(uuids.size());
        DataFetcherResult.Builder result = DataFetcherResult.newResult();
        for (String uuid : uuids) {
            try {
                nodes.add(this.getGqlNodeById(uuid, validInLanguage));
            }
            catch (RepositoryException re) {
                result.error(JahiaDataFetchingExceptionHandler.transformException((Throwable)((Object)new DataFetchingException(re)), environment));
            }
        }
        return result.data(nodes).build();
    }

    @GraphQLField
    @GraphQLNonNull
    @GraphQLName(value="nodesByPath")
    @GraphQLDescription(value="Get GraphQL representations of multiple nodes by their paths")
    public DataFetcherResult<Collection<GqlJcrNode>> getNodesByPath(@GraphQLName(value="paths") @GraphQLNonNull @GraphQLDescription(value="The paths of the nodes") @GraphQLNonNull Collection<@GraphQLNonNull String> paths, @GraphQLName(value="validInLanguage") @GraphQLDescription(value="Check node validity in this language. \n\n Node validity is determined by multiple conditions: \n\n * The node exists \n * The node is not attached to a visibility condition preventing its display \n * The node is published in this language \n * The node's language has not been invalidated.") String validInLanguage, DataFetchingEnvironment environment) {
        ArrayList<GqlJcrNode> nodes = new ArrayList<GqlJcrNode>(paths.size());
        DataFetcherResult.Builder result = DataFetcherResult.newResult();
        for (String path : paths) {
            try {
                nodes.add(this.getGqlNodeByPath(path, validInLanguage));
            }
            catch (RepositoryException re) {
                result.error(JahiaDataFetchingExceptionHandler.transformException((Throwable)((Object)new DataFetchingException(re)), environment));
            }
        }
        return result.data(nodes).build();
    }

    @GraphQLField
    @GraphQLName(value="nodesByQuery")
    @GraphQLDescription(value="Get GraphQL representations of nodes using a query language supported by JCR")
    @GraphQLConnection(connectionFetcher=DXPaginatedDataConnectionFetcher.class)
    public DXPaginatedData<GqlJcrNode> getNodesByQuery(@GraphQLName(value="query") @GraphQLNonNull @GraphQLDescription(value="The query string") String query, @GraphQLName(value="queryLanguage") @GraphQLDefaultValue(value=QueryLanguageDefaultValue.class) @GraphQLDescription(value="The query language") QueryLanguage queryLanguage, @GraphQLName(value="language") @GraphQLDescription(value="Language to use for the query") String language, @GraphQLName(value="fieldFilter") @GraphQLDescription(value="Filter by graphQL fields values") FieldFiltersInput fieldFilter, @GraphQLName(value="fieldSorter") @GraphQLDescription(value="Sort by GraphQL field values") FieldSorterInput fieldSorter, @GraphQLName(value="fieldGrouping") @GraphQLDescription(value="Group fields by criteria") FieldGroupingInput fieldGrouping, DataFetchingEnvironment environment) {
        try {
            QueryManagerWrapper queryManager = this.getSession(language).getWorkspace().getQueryManager();
            QueryWrapper q = queryManager.createQuery(query, queryLanguage.getJcrQueryLanguage());
            JCRNodeIteratorWrapper nodes = q.execute().getNodes();
            return NodeHelper.getPaginatedNodesList((NodeIterator)nodes, null, null, null, fieldFilter, environment, fieldSorter, fieldGrouping);
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="nodesByCriteria")
    @GraphQLDescription(value="handles query nodes with QOM factory")
    @GraphQLConnection(connectionFetcher=DXPaginatedDataConnectionFetcher.class)
    public DXPaginatedData<GqlJcrNode> getNodesByCriteria(@GraphQLName(value="criteria") @GraphQLNonNull @GraphQLDescription(value="The criteria to fetch nodes by") GqlJcrNodeCriteriaInput criteria, @GraphQLName(value="fieldFilter") @GraphQLDescription(value="Filter by GraphQL field values") FieldFiltersInput fieldFilter, @GraphQLName(value="fieldSorter") @GraphQLDescription(value="sort by GraphQL field values") FieldSorterInput fieldSorter, @GraphQLName(value="fieldGrouping") @GraphQLDescription(value="Group fields by criteria") FieldGroupingInput fieldGrouping, DataFetchingEnvironment environment) {
        try {
            Ordering[] orderingArray;
            JCRSessionWrapper session = this.getSession(criteria.getLanguage());
            QueryObjectModelFactory factory = session.getWorkspace().getQueryManager().getQOMFactory();
            GqlConstraintHandler handler = new GqlConstraintHandler(factory, session.getValueFactory());
            Selector source = factory.selector(criteria.getNodeType(), "node");
            Constraint constraintTree = handler.getConstraintTree(source.getSelectorName(), criteria);
            Ordering ordering = handler.getOrderingByProperty(source.getSelectorName(), criteria);
            if (ordering == null) {
                orderingArray = null;
            } else {
                Ordering[] orderingArray2 = new Ordering[1];
                orderingArray = orderingArray2;
                orderingArray2[0] = ordering;
            }
            QueryObjectModel queryObjectModel = factory.createQuery((Source)source, constraintTree, orderingArray, null);
            NodeIterator it = queryObjectModel.execute().getNodes();
            return NodeHelper.getPaginatedNodesList(it, null, null, null, fieldFilter, environment, fieldSorter, fieldGrouping);
        }
        catch (WrappedException e) {
            Throwable cause = e.getCause();
            while (cause instanceof WrappedException) {
                cause = cause.getCause();
            }
            if (cause instanceof BaseGqlClientException) {
                throw (BaseGqlClientException)((Object)cause);
            }
            throw new DataFetchingException(cause);
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    private GqlJcrNode getGqlNodeByPath(String path, String validInLanguage) throws RepositoryException {
        return SpecializedTypesHandler.getNode(this.getSession(validInLanguage).getNode(JCRContentUtils.escapeNodePath((String)path)));
    }

    private GqlJcrNode getGqlNodeById(String uuid, String validInLanguage) throws RepositoryException {
        return SpecializedTypesHandler.getNode(this.getSession(validInLanguage).getNodeByIdentifier(uuid));
    }

    private JCRSessionWrapper getSession() throws RepositoryException {
        return JCRSessionFactory.getInstance().getCurrentUserSession(this.workspace.getValue());
    }

    private JCRSessionWrapper getSession(String language) throws RepositoryException {
        if (language == null) {
            return this.getSession();
        }
        Locale locale = LocaleUtils.toLocale((String)language);
        return JCRSessionFactory.getInstance().getCurrentUserSession(this.workspace.getValue(), locale);
    }

    public static class QueryLanguageDefaultValue
    implements Supplier<Object> {
        @Override
        public QueryLanguage get() {
            return QueryLanguage.SQL2;
        }
    }

    @GraphQLDescription(value="JCR query languages available to use for nodes querying")
    public static enum QueryLanguage {
        SQL2("JCR-SQL2"),
        XPATH("xpath");

        private String jcrQueryLanguage;

        private QueryLanguage(String jcrQueryLanguage) {
            this.jcrQueryLanguage = jcrQueryLanguage;
        }

        public String getJcrQueryLanguage() {
            return this.jcrQueryLanguage;
        }
    }
}

