/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.node;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.schema.DataFetchingEnvironment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.fileupload.FileUploadBase;
import org.jahia.modules.graphql.provider.dxm.BaseGqlClientException;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrMutationSupport;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrProperty;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrPropertyOption;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrPropertyType;
import org.jahia.modules.graphql.provider.dxm.node.NodeHelper;
import org.jahia.modules.graphql.provider.dxm.node.NodeMutationConstraintViolationHandler;
import org.jahia.modules.graphql.provider.dxm.node.SpecializedTypesHandler;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;

@GraphQLName(value="JCRPropertyMutation")
@GraphQLDescription(value="Mutations on a JCR property")
public class GqlJcrPropertyMutation
extends GqlJcrMutationSupport {
    private JCRNodeWrapper node;
    private String name;

    public GqlJcrPropertyMutation(JCRNodeWrapper node, String name) {
        this.node = node;
        this.name = name;
    }

    public GqlJcrPropertyMutation(JCRPropertyWrapper property) {
        try {
            this.node = property.getParent();
            this.name = property.getName();
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="property")
    @GraphQLDescription(value="Get the graphQL representation of the property currently being mutated")
    public GqlJcrProperty getProperty() throws BaseGqlClientException {
        try {
            return new GqlJcrProperty(this.node.getProperty(this.name), SpecializedTypesHandler.getNode(this.node));
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="path")
    @GraphQLDescription(value="Get the path of the property currently being mutated")
    public String getPath() throws BaseGqlClientException {
        return this.node.getPath() + "/" + this.name;
    }

    @GraphQLField
    @GraphQLName(value="setValue")
    @GraphQLDescription(value="Set property value")
    public boolean setValue(@GraphQLName(value="language") String language, @GraphQLName(value="type") GqlJcrPropertyType type, @GraphQLName(value="option") GqlJcrPropertyOption option, @GraphQLName(value="value") String value, DataFetchingEnvironment environment) throws BaseGqlClientException {
        try {
            JCRNodeWrapper localizedNode = NodeHelper.getNodeInLanguage(this.node, language);
            localizedNode.setProperty(this.name, GqlJcrPropertyMutation.getValue(this.getPropertyType(type), option, value, localizedNode.getSession(), environment));
            localizedNode.getSession().validate();
        }
        catch (IOException | RepositoryException | FileUploadBase.FileSizeLimitExceededException e) {
            throw NodeMutationConstraintViolationHandler.transformException(e);
        }
        return true;
    }

    @GraphQLField
    @GraphQLName(value="setValues")
    @GraphQLDescription(value="Set property values")
    public boolean setValues(@GraphQLName(value="language") String language, @GraphQLName(value="type") GqlJcrPropertyType type, @GraphQLName(value="option") GqlJcrPropertyOption option, @GraphQLName(value="values") List<String> values, DataFetchingEnvironment environment) throws BaseGqlClientException {
        try {
            JCRNodeWrapper localizedNode = NodeHelper.getNodeInLanguage(this.node, language);
            localizedNode.setProperty(this.name, this.getValues(type, option, values, localizedNode.getSession(), environment));
            localizedNode.getSession().validate();
        }
        catch (IOException | RepositoryException | FileUploadBase.FileSizeLimitExceededException e) {
            throw NodeMutationConstraintViolationHandler.transformException(e);
        }
        return true;
    }

    @GraphQLField
    @GraphQLDescription(value="Add a new value to this property")
    public boolean addValue(@GraphQLName(value="language") String language, @GraphQLName(value="type") GqlJcrPropertyType type, @GraphQLName(value="option") GqlJcrPropertyOption option, @GraphQLName(value="value") String value, DataFetchingEnvironment environment) throws BaseGqlClientException {
        try {
            JCRNodeWrapper localizedNode = NodeHelper.getNodeInLanguage(this.node, language);
            localizedNode.getProperty(this.name).addValue(GqlJcrPropertyMutation.getValue(this.getPropertyType(type), option, value, localizedNode.getSession(), environment));
            localizedNode.getSession().validate();
        }
        catch (IOException | RepositoryException | FileUploadBase.FileSizeLimitExceededException e) {
            throw NodeMutationConstraintViolationHandler.transformException(e);
        }
        return true;
    }

    @GraphQLField
    @GraphQLDescription(value="Remove a new value from this property")
    public boolean removeValue(@GraphQLName(value="language") String language, @GraphQLName(value="type") GqlJcrPropertyType type, @GraphQLName(value="option") GqlJcrPropertyOption option, @GraphQLName(value="value") String value, DataFetchingEnvironment environment) throws BaseGqlClientException {
        try {
            JCRNodeWrapper localizedNode = NodeHelper.getNodeInLanguage(this.node, language);
            localizedNode.getProperty(this.name).removeValue(GqlJcrPropertyMutation.getValue(this.getPropertyType(type), option, value, localizedNode.getSession(), environment));
            localizedNode.getSession().validate();
        }
        catch (IOException | RepositoryException | FileUploadBase.FileSizeLimitExceededException e) {
            throw NodeMutationConstraintViolationHandler.transformException(e);
        }
        return true;
    }

    @GraphQLField
    @GraphQLDescription(value="Add new values to this property")
    public boolean addValues(@GraphQLName(value="language") String language, @GraphQLName(value="type") GqlJcrPropertyType type, @GraphQLName(value="option") GqlJcrPropertyOption option, @GraphQLName(value="values") List<String> values, DataFetchingEnvironment environment) throws BaseGqlClientException {
        try {
            JCRNodeWrapper localizedNode = NodeHelper.getNodeInLanguage(this.node, language);
            localizedNode.getProperty(this.name).addValues(this.getValues(type, option, values, localizedNode.getSession(), environment));
            localizedNode.getSession().validate();
        }
        catch (IOException | RepositoryException | FileUploadBase.FileSizeLimitExceededException e) {
            throw NodeMutationConstraintViolationHandler.transformException(e);
        }
        return true;
    }

    @GraphQLField
    @GraphQLDescription(value="Remove values from this property")
    public boolean removeValues(@GraphQLName(value="language") String language, @GraphQLName(value="type") GqlJcrPropertyType type, @GraphQLName(value="option") GqlJcrPropertyOption option, @GraphQLName(value="values") List<String> values, DataFetchingEnvironment environment) throws BaseGqlClientException {
        try {
            JCRNodeWrapper localizedNode = NodeHelper.getNodeInLanguage(this.node, language);
            localizedNode.getProperty(this.name).removeValues(this.getValues(type, option, values, localizedNode.getSession(), environment));
            localizedNode.getSession().validate();
        }
        catch (IOException | RepositoryException | FileUploadBase.FileSizeLimitExceededException e) {
            throw NodeMutationConstraintViolationHandler.transformException(e);
        }
        return true;
    }

    @GraphQLField
    @GraphQLDescription(value="Delete this property")
    public boolean delete(@GraphQLName(value="language") String language) throws BaseGqlClientException {
        try {
            JCRNodeWrapper localizedNode = NodeHelper.getNodeInLanguage(this.node, language);
            localizedNode.getProperty(this.name).remove();
            localizedNode.getSession().validate();
        }
        catch (RepositoryException e) {
            throw NodeMutationConstraintViolationHandler.transformException(e);
        }
        return true;
    }

    private int getPropertyType(GqlJcrPropertyType type) throws RepositoryException {
        if (type != null) {
            return type.getValue();
        }
        ExtendedPropertyDefinition def = this.node.getApplicablePropertyDefinition(this.name);
        return def != null && def.getRequiredType() != 0 ? def.getRequiredType() : 1;
    }

    private Value[] getValues(GqlJcrPropertyType type, GqlJcrPropertyOption option, List<String> values, JCRSessionWrapper session, DataFetchingEnvironment environment) throws RepositoryException, IOException, FileUploadBase.FileSizeLimitExceededException {
        ArrayList<Value> jcrValues = new ArrayList<Value>();
        int jcrType = this.getPropertyType(type);
        for (String string : values == null ? Collections.emptyList() : values) {
            jcrValues.add(GqlJcrPropertyMutation.getValue(jcrType, option, string, session, environment));
        }
        return jcrValues.toArray(new Value[0]);
    }
}

