/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.node;

import com.google.common.collect.Lists;
import graphql.annotations.annotationTypes.GraphQLDefaultValue;
import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.BaseGqlClientException;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.acl.service.JahiaAclService;
import org.jahia.modules.graphql.provider.dxm.image.GqlJcrImageTransformMutation;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrMutationSupport;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNodeInput;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrPropertyInput;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrPropertyMutation;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrWrongInputException;
import org.jahia.modules.graphql.provider.dxm.node.GqlZipMutation;
import org.jahia.modules.graphql.provider.dxm.node.NodeHelper;
import org.jahia.modules.graphql.provider.dxm.node.SpecializedTypesHandler;
import org.jahia.modules.graphql.provider.dxm.osgi.annotations.GraphQLOsgiService;
import org.jahia.modules.graphql.provider.dxm.predicate.PredicateHelper;
import org.jahia.modules.graphql.provider.dxm.user.PrincipalType;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.nodetypes.ExtendedNodeType;

@GraphQLName(value="JCRNodeMutation")
@GraphQLDescription(value="Mutations on a JCR node")
public class GqlJcrNodeMutation
extends GqlJcrMutationSupport {
    @Inject
    @GraphQLOsgiService
    private JahiaAclService aclService;
    public JCRNodeWrapper jcrNode;

    public GqlJcrNodeMutation(JCRNodeWrapper node) {
        this.jcrNode = node;
    }

    @GraphQLField
    @GraphQLName(value="node")
    @GraphQLDescription(value="Get the graphQL representation of the node currently being mutated")
    public GqlJcrNode getNode() throws BaseGqlClientException {
        try {
            return SpecializedTypesHandler.getNode(this.jcrNode);
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="uuid")
    @GraphQLDescription(value="Get the identifier of the node currently being mutated")
    public String getUuid() throws BaseGqlClientException {
        try {
            return this.jcrNode.getIdentifier();
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLDescription(value="Creates a new JCR node under the current node")
    public GqlJcrNodeMutation addChild(@GraphQLName(value="name") @GraphQLNonNull @GraphQLDescription(value="The name of the node to create") String name, @GraphQLName(value="primaryNodeType") @GraphQLNonNull @GraphQLDescription(value="The primary node type of the node to create") String primaryNodeType, @GraphQLName(value="useAvailableNodeName") @GraphQLDescription(value="If true, use the next available name for a node, appending if needed numbers. Default is false") Boolean useAvailableNodeName, @GraphQLName(value="mixins") @GraphQLDescription(value="The collection of mixin type names") Collection<String> mixins, @GraphQLName(value="properties") Collection<GqlJcrPropertyInput> properties, @GraphQLName(value="children") Collection<GqlJcrNodeInput> children) throws BaseGqlClientException {
        GqlJcrNodeInput node = new GqlJcrNodeInput(name, primaryNodeType, useAvailableNodeName, mixins, properties, children);
        return new GqlJcrNodeMutation(GqlJcrNodeMutation.addNode(this.jcrNode, node));
    }

    @GraphQLField
    @GraphQLDescription(value="Batch creates a number of new JCR nodes under the current node")
    public Collection<GqlJcrNodeMutation> addChildrenBatch(@GraphQLName(value="nodes") @GraphQLNonNull @GraphQLDescription(value="The collection of nodes to create") Collection<GqlJcrNodeInput> nodes) throws BaseGqlClientException {
        ArrayList<GqlJcrNodeMutation> result = new ArrayList<GqlJcrNodeMutation>();
        for (GqlJcrNodeInput node : nodes) {
            result.add(new GqlJcrNodeMutation(GqlJcrNodeMutation.addNode(this.jcrNode, node)));
        }
        return result;
    }

    @GraphQLField
    @GraphQLDescription(value="Import a file under the current node")
    public boolean importContent(@GraphQLName(value="file") @GraphQLNonNull @GraphQLDescription(value="Name of the request part that contains desired import file body") String file, DataFetchingEnvironment environment) throws BaseGqlClientException {
        GqlJcrNodeMutation.importFileUpload(file, this.jcrNode, environment);
        return true;
    }

    @GraphQLField
    @GraphQLDescription(value="Mutates an existing sub node, based on its relative path to the current node")
    public GqlJcrNodeMutation mutateDescendant(@GraphQLName(value="relPath") @GraphQLNonNull @GraphQLDescription(value="Name or relative path of the sub node to mutate") String relPath) throws BaseGqlClientException {
        if (relPath.contains("..")) {
            throw new GqlJcrWrongInputException("No navigation outside of the node sub-tree is supported");
        }
        try {
            return new GqlJcrNodeMutation(this.jcrNode.getNode(relPath));
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLDescription(value="Mutates a set of existing descendant nodes, based on filters passed as parameter")
    public Collection<GqlJcrNodeMutation> mutateDescendants(@GraphQLName(value="typesFilter") @GraphQLDescription(value="Filter of descendant nodes by their types; null to avoid such filtering") GqlJcrNode.NodeTypesInput typesFilter, @GraphQLName(value="propertiesFilter") @GraphQLDescription(value="Filter of descendant nodes by their property values; null to avoid such filtering") GqlJcrNode.NodePropertiesInput propertiesFilter, @GraphQLName(value="recursionTypesFilter") @GraphQLDescription(value="Filter out and stop recursion on nodes by their types; null to avoid such filtering") GqlJcrNode.NodeTypesInput recursionTypesFilter, @GraphQLName(value="recursionPropertiesFilter") @GraphQLDescription(value="Filter out and stop recursion on nodes by their property values; null to avoid such filtering") GqlJcrNode.NodePropertiesInput recursionPropertiesFilter) throws BaseGqlClientException {
        LinkedList<GqlJcrNodeMutation> descendants = new LinkedList<GqlJcrNodeMutation>();
        try {
            NodeHelper.collectDescendants(this.jcrNode, NodeHelper.getNodesPredicate(null, typesFilter, propertiesFilter, null), NodeHelper.getNodesPredicate(null, recursionTypesFilter, recursionPropertiesFilter, null), descendant -> descendants.add(new GqlJcrNodeMutation((JCRNodeWrapper)descendant)));
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
        return descendants;
    }

    @GraphQLField
    @GraphQLDescription(value="Mutates a set of existing direct sub nodes, based on filters passed as parameter")
    public Collection<GqlJcrNodeMutation> mutateChildren(@GraphQLName(value="names") @GraphQLDescription(value="Filter of child nodes by their names; null to avoid such filtering") Collection<String> names, @GraphQLName(value="typesFilter") @GraphQLDescription(value="Filter of child nodes by their types; null to avoid such filtering") GqlJcrNode.NodeTypesInput typesFilter, @GraphQLName(value="propertiesFilter") @GraphQLDescription(value="Filter of child nodes by their property values; null to avoid such filtering") GqlJcrNode.NodePropertiesInput propertiesFilter) throws BaseGqlClientException {
        LinkedList<GqlJcrNodeMutation> children = new LinkedList<GqlJcrNodeMutation>();
        try {
            NodeHelper.collectDescendants(this.jcrNode, NodeHelper.getNodesPredicate(names, typesFilter, propertiesFilter, null), PredicateHelper.falsePredicate(), child -> children.add(new GqlJcrNodeMutation((JCRNodeWrapper)child)));
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
        return children;
    }

    @GraphQLField
    @GraphQLDescription(value="Mutates or creates a property on the current node")
    public GqlJcrPropertyMutation mutateProperty(@GraphQLName(value="name") @GraphQLNonNull @GraphQLDescription(value="The name of the property to update") String propertyName) {
        return new GqlJcrPropertyMutation(this.jcrNode, propertyName);
    }

    @GraphQLField
    @GraphQLDescription(value="Mutates or creates a set of properties on the current node")
    public Collection<GqlJcrPropertyMutation> mutateProperties(@GraphQLName(value="names") @GraphQLDescription(value="The names of the JCR properties; null to obtain all properties") Collection<String> names) {
        return names.stream().map(name -> new GqlJcrPropertyMutation(this.jcrNode, (String)name)).collect(Collectors.toList());
    }

    @GraphQLField
    @GraphQLName(value="setPropertiesBatch")
    @GraphQLDescription(value="Mutates or creates a set of properties on the current node")
    public Collection<GqlJcrPropertyMutation> setPropertiesBatch(@GraphQLName(value="properties") @GraphQLDescription(value="The collection of JCR properties to set") Collection<GqlJcrPropertyInput> properties) throws BaseGqlClientException {
        return GqlJcrNodeMutation.setProperties(this.jcrNode, properties).stream().map(GqlJcrPropertyMutation::new).collect(Collectors.toList());
    }

    @GraphQLField
    @GraphQLDescription(value="Adds mixin types on the current node")
    public Collection<String> addMixins(@GraphQLName(value="mixins") @GraphQLNonNull @GraphQLDescription(value="The collection of mixin type names") Collection<String> mixins) throws BaseGqlClientException {
        try {
            for (String mixin : mixins) {
                this.jcrNode.addMixin(mixin);
            }
            return Arrays.stream(this.jcrNode.getMixinNodeTypes()).map(ExtendedNodeType::getName).collect(Collectors.toList());
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLDescription(value="Removes mixin types on the current node")
    public Collection<String> removeMixins(@GraphQLName(value="mixins") @GraphQLNonNull @GraphQLDescription(value="The collection of mixin type names") Collection<String> mixins) throws BaseGqlClientException {
        try {
            for (String mixin : mixins) {
                this.jcrNode.removeMixin(mixin);
            }
            return Arrays.stream(this.jcrNode.getMixinNodeTypes()).map(ExtendedNodeType::getName).collect(Collectors.toList());
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLDescription(value="Rename the current node")
    public String rename(@GraphQLName(value="name") @GraphQLNonNull @GraphQLDescription(value="The new name of the node") String newName) throws BaseGqlClientException {
        try {
            this.jcrNode.rename(newName);
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
        return this.jcrNode.getPath();
    }

    @GraphQLField
    @GraphQLDescription(value="Moves the current node to a specified destination path (if destPath is specified) or moves it under the specified node (if parentPathOrId is specified). Either of two parameters is expected.")
    public String move(@GraphQLName(value="destPath") @GraphQLDescription(value="The target node path of the current node after the move operation") String destPath, @GraphQLName(value="parentPathOrId") @GraphQLDescription(value="The parent node path or id under which the current node will be moved to") String parentPathOrId) throws BaseGqlClientException {
        block4: {
            try {
                if (destPath != null) {
                    this.jcrNode.getSession().move(this.jcrNode.getPath(), destPath);
                    break block4;
                }
                if (parentPathOrId != null) {
                    JCRNodeWrapper parentDest = GqlJcrNodeMutation.getNodeFromPathOrId(this.jcrNode.getSession(), parentPathOrId);
                    this.jcrNode.getSession().move(this.jcrNode.getPath(), parentDest.getPath() + "/" + this.jcrNode.getName());
                    break block4;
                }
                throw new GqlJcrWrongInputException("Either destPath or parentPathOrId is expected for the node move operation");
            }
            catch (RepositoryException e) {
                throw new DataFetchingException(e);
            }
        }
        return this.jcrNode.getPath();
    }

    @GraphQLField
    @GraphQLDescription(value="Delete the current node (and its subgraph)")
    public boolean delete() throws BaseGqlClientException {
        try {
            this.jcrNode.remove();
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
        return true;
    }

    @GraphQLField
    @GraphQLDescription(value="Mark the current node (and its subgraph) for deletion")
    public boolean markForDeletion(@GraphQLName(value="comment") @GraphQLDescription(value="Optional deletion comment") String comment) throws BaseGqlClientException {
        try {
            this.jcrNode.markForDeletion(comment);
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
        return true;
    }

    @GraphQLField
    @GraphQLDescription(value="Unmark this node and all the sub-nodes for deletion")
    public boolean unmarkForDeletion() throws BaseGqlClientException {
        try {
            this.jcrNode.unmarkForDeletion();
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
        return true;
    }

    @GraphQLField
    @GraphQLDescription(value="Return image transformation mutation")
    public GqlJcrImageTransformMutation transformImage(@GraphQLName(value="name") @GraphQLDescription(value="name of target file, if different") String name, @GraphQLName(value="targetPath") @GraphQLDescription(value="target path, if different") String targetPath) throws BaseGqlClientException {
        try {
            if (this.jcrNode.isNodeType("jmix:image")) {
                return new GqlJcrImageTransformMutation(this.jcrNode, name != null ? JCRContentUtils.escapeLocalNodeName((String)name) : null, targetPath != null ? JCRContentUtils.escapeNodePath((String)targetPath) : null);
            }
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
        return null;
    }

    @GraphQLField
    @GraphQLDescription(value="Return zip mutation")
    public GqlZipMutation zip() throws DataFetchingException {
        if (this.jcrNode.isFile()) {
            return new GqlZipMutation(this.jcrNode);
        }
        throw new DataFetchingException(this.jcrNode.getPath() + " is not a file");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GraphQLField
    @GraphQLDescription(value="Reorder child nodes according to the list of names passed")
    public boolean reorderChildren(@GraphQLName(value="names") @GraphQLNonNull @GraphQLDescription(value="List of child node names in the desired order") List<String> names, @GraphQLName(value="position") @GraphQLDefaultValue(value=ReorderedChildrenPositionDefaultValue.class) @GraphQLDescription(value="The target position of reordered child nodes. The default value is inplace.") ReorderedChildrenPosition position) throws BaseGqlClientException {
        this.validateChildNamesToReorder(names, position);
        try {
            String destChildName = null;
            for (String srcChildName : Lists.reverse(names)) {
                if (destChildName == null) {
                    if (position == ReorderedChildrenPosition.LAST) {
                        this.jcrNode.orderBefore(srcChildName, null);
                    } else if (position == ReorderedChildrenPosition.FIRST) {
                        Iterator childNodeIterator = this.jcrNode.getNodes().iterator();
                        if (!childNodeIterator.hasNext()) throw new GqlJcrWrongInputException("Node " + this.jcrNode.getPath() + " has no children to reorder");
                        this.jcrNode.orderBefore(srcChildName, ((JCRNodeWrapper)childNodeIterator.next()).getName());
                    }
                } else {
                    this.jcrNode.orderBefore(srcChildName, destChildName);
                }
                destChildName = srcChildName;
            }
            return true;
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLDescription(value="Grant role permissions to specified principal user/group for the given node")
    public boolean grantRoles(@GraphQLName(value="roleNames") @GraphQLDescription(value="Roles to grant user/group for this node") @GraphQLNonNull List<String> roleNames, @GraphQLName(value="principalType") @GraphQLDescription(value="Type of principal (user/group) specified") @GraphQLNonNull PrincipalType principalType, @GraphQLName(value="principalName") @GraphQLDescription(value="Name of principal (user/group)") @GraphQLNonNull String principalName) throws RepositoryException {
        String principalKey = principalType.getPrincipalKey(principalName);
        return this.aclService.grantRoles(this.jcrNode, principalKey, roleNames);
    }

    @GraphQLField
    @GraphQLDescription(value="Remove/deny roles to specified principal user/group for the given node")
    public boolean revokeRoles(@GraphQLName(value="roleNames") @GraphQLDescription(value="Roles to grant user/group for this node") @GraphQLNonNull List<String> roleNames, @GraphQLName(value="principalType") @GraphQLDescription(value="Type of principal (user/group) specified") @GraphQLNonNull PrincipalType principalType, @GraphQLName(value="principalName") @GraphQLDescription(value="Name of principal (user/group)") @GraphQLNonNull String principalName) throws RepositoryException {
        String principalKey = principalType.getPrincipalKey(principalName);
        return this.aclService.revokeRoles(this.jcrNode, principalKey, roleNames);
    }

    private void validateChildNamesToReorder(List<String> names, ReorderedChildrenPosition position) {
        if (names == null || names.isEmpty()) {
            throw new GqlJcrWrongInputException("A non-empty list of child node names is expected");
        }
        if (names.size() == 1) {
            if (position == ReorderedChildrenPosition.INPLACE) {
                throw new GqlJcrWrongInputException("Reorder operation expects at least two names in case target position is inplace");
            }
        } else {
            LinkedHashSet<String> uniqueNames = new LinkedHashSet<String>(names);
            if (uniqueNames.size() != names.size()) {
                throw new GqlJcrWrongInputException("Ambigous child name order: duplicates are not expected in the list of passed child node names to reorder");
            }
            if (names.indexOf(null) != -1 || names.indexOf("") != -1) {
                throw new GqlJcrWrongInputException("Null or empty child names are not permitted");
            }
        }
    }

    public static class ReorderedChildrenPositionDefaultValue
    implements Supplier<Object> {
        @Override
        public ReorderedChildrenPosition get() {
            return ReorderedChildrenPosition.INPLACE;
        }
    }

    @GraphQLDescription(value="The target position of reordered child nodes")
    public static enum ReorderedChildrenPosition {
        LAST,
        INPLACE,
        FIRST;

    }
}

