/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.node;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import java.util.Collection;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNodeConstraintInput;
import org.jahia.modules.graphql.provider.dxm.node.GqlOrdering;

@GraphQLDescription(value="Node criterias")
public class GqlJcrNodeCriteriaInput {
    private String nodeType;
    private PathType pathType;
    private Collection<String> paths;
    private GqlJcrNodeConstraintInput nodeConstraint;
    private String language;
    private GqlOrdering ordering;

    public GqlJcrNodeCriteriaInput(@GraphQLName(value="nodeType") @GraphQLNonNull @GraphQLDescription(value="The type of nodes to fetch") String nodeType, @GraphQLName(value="pathType") @GraphQLDescription(value="The exact meaning of the paths parameter, ANCESTOR by default") PathType pathType, @GraphQLName(value="paths") @GraphQLDescription(value="Paths that restrict areas to fetch nodes from; the exact meaning is defined by the pathType parameter; null or empty array means no path restrictions") Collection<String> paths, @GraphQLName(value="nodeConstraint") @GraphQLDescription(value="Additional constraint to filter nodes by their arbitrary properties") GqlJcrNodeConstraintInput nodeConstraint, @GraphQLName(value="language") @GraphQLDescription(value="Language to access node properties in; must be a valid language code in case any internationalized properties are used for filtering, does not matter for non-internationalized ones") String language, @GraphQLName(value="ordering") @GraphQLDescription(value="Ordering strategies") GqlOrdering ordering) {
        this.nodeType = nodeType;
        this.paths = paths;
        this.pathType = pathType;
        this.nodeConstraint = nodeConstraint;
        this.ordering = ordering;
        this.language = language;
    }

    @GraphQLField
    @GraphQLName(value="nodeType")
    @GraphQLNonNull
    @GraphQLDescription(value="The type of nodes to query")
    public String getNodeType() {
        return this.nodeType;
    }

    @GraphQLField
    @GraphQLName(value="pathType")
    @GraphQLDescription(value="The exact meaning of the paths field")
    public PathType getPathType() {
        return this.pathType;
    }

    @GraphQLField
    @GraphQLName(value="paths")
    @GraphQLDescription(value="Paths that restrict areas to fetch nodes from; the exact meaning is defined by the pathType field; null or empty collection means no path restrictions")
    public Collection<String> getPaths() {
        return this.paths;
    }

    @GraphQLField
    @GraphQLName(value="nodeConstraint")
    @GraphQLDescription(value="Additional constraint to filter nodes by their arbitrary properties")
    public GqlJcrNodeConstraintInput getNodeConstraint() {
        return this.nodeConstraint;
    }

    @GraphQLField
    @GraphQLName(value="language")
    @GraphQLDescription(value="Language to access node properties in")
    public String getLanguage() {
        return this.language;
    }

    @GraphQLField
    @GraphQLName(value="ordering")
    @GraphQLDescription(value="Ordering strategies")
    public GqlOrdering getOrdering() {
        return this.ordering;
    }

    public static enum PathType {
        ANCESTOR,
        PARENT,
        OWN;

    }
}

