/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.node;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import java.util.List;

@GraphQLDescription(value="An optional part of the JCR node criteria to filter nodes, specifically by their arbitrary properties")
public class GqlJcrNodeConstraintInput {
    private String like;
    private String contains;
    private String property;
    private QueryFunction function;
    private String equals;
    private String notEquals;
    private String lt;
    private String gt;
    private String lte;
    private String gte;
    private Boolean exists;
    private Integer lastDays;
    private List<GqlJcrNodeConstraintInput> all;
    private List<GqlJcrNodeConstraintInput> any;
    private List<GqlJcrNodeConstraintInput> none;

    public GqlJcrNodeConstraintInput(@GraphQLName(value="like") @GraphQLDescription(value="A value to compare the node property value to, using the 'like' operator") String like, @GraphQLName(value="contains") @GraphQLDescription(value="A search expression to match the node property value(s) against, either specific property only or all node properties, dependent on the 'property' parameter value passed") String contains, @GraphQLName(value="property") @GraphQLDescription(value="The name of the node property to compare/match; may be null when optional or not applicable, dependent on other parameter values") String property, @GraphQLName(value="function") @GraphQLDescription(value="The query function name for the node for comparison") QueryFunction function, @GraphQLName(value="equals") @GraphQLDescription(value="A value to compare the node property value to, using the 'equals to' operator") String equals, @GraphQLName(value="notEquals") @GraphQLDescription(value="A value to compare the node property value to, using the 'not equals to' operator") String notEquals, @GraphQLName(value="lt") @GraphQLDescription(value="A value to compare the node property value to, using the 'less than' operator") String lt, @GraphQLName(value="gt") @GraphQLDescription(value="A value to compare the node property value to, using the 'greater than' operator") String gt, @GraphQLName(value="lte") @GraphQLDescription(value="A value to compare the node property value to, using the 'less than or equals to' operator") String lte, @GraphQLName(value="gte") @GraphQLDescription(value="A value to compare the node property value to, using the 'greater than or equals to' operator") String gte, @GraphQLName(value="exists") @GraphQLDescription(value="A value to compare the node property value to, using the 'exists' operator") Boolean exists, @GraphQLName(value="lastDays") @GraphQLDescription(value="A value to compare the node property value to, using the 'exists' operator") Integer lastDays, @GraphQLName(value="all") @GraphQLDescription(value="A list of child constraint input for all composition") List<GqlJcrNodeConstraintInput> all, @GraphQLName(value="any") @GraphQLDescription(value="A list of child constraint input for any composition") List<GqlJcrNodeConstraintInput> any, @GraphQLName(value="none") @GraphQLDescription(value="A list of child constraint input for none composition") List<GqlJcrNodeConstraintInput> none) {
        this.like = like;
        this.contains = contains;
        this.property = property;
        this.function = function;
        this.equals = equals;
        this.notEquals = notEquals;
        this.lt = lt;
        this.gt = gt;
        this.lte = lte;
        this.gte = gte;
        this.exists = exists;
        this.lastDays = lastDays;
        this.all = all;
        this.any = any;
        this.none = none;
    }

    @GraphQLField
    @GraphQLName(value="like")
    @GraphQLDescription(value="A value to compare the node property value to, using the 'like' operator")
    public String getLike() {
        return this.like;
    }

    @GraphQLField
    @GraphQLName(value="contains")
    @GraphQLDescription(value="A search expression to match the node property value(s) against, either specific property only or all node properties, dependent on the 'property' parameter value passed")
    public String getContains() {
        return this.contains;
    }

    @GraphQLField
    @GraphQLName(value="property")
    @GraphQLDescription(value="The name of the node property to compare/match; may be null when optional or not applicable, dependent on other parameter values")
    public String getProperty() {
        return this.property;
    }

    @GraphQLField
    @GraphQLName(value="function")
    @GraphQLDescription(value="The query function name for the node for comparison")
    public QueryFunction getFunction() {
        return this.function;
    }

    @GraphQLField
    @GraphQLName(value="equals")
    @GraphQLDescription(value="A value to compare the node property value to, using the 'equals to' operator")
    public String getEquals() {
        return this.equals;
    }

    @GraphQLField
    @GraphQLName(value="notEquals")
    @GraphQLDescription(value="A value to compare the node property value to, using the 'not equals to' operator")
    public String getNotEquals() {
        return this.notEquals;
    }

    @GraphQLField
    @GraphQLName(value="lt")
    @GraphQLDescription(value="A value to compare the node property value to, using the 'less than' operator")
    public String getLt() {
        return this.lt;
    }

    @GraphQLField
    @GraphQLName(value="gt")
    @GraphQLDescription(value="A value to compare the node property value to, using the 'greater than' operator")
    public String getGt() {
        return this.gt;
    }

    @GraphQLField
    @GraphQLName(value="lte")
    @GraphQLDescription(value="A value to compare the node property value to, using the 'less than or equals to' operator")
    public String getLte() {
        return this.lte;
    }

    @GraphQLField
    @GraphQLName(value="gte")
    @GraphQLDescription(value="A value to compare the node property value to, using the 'greater than or equals to' operator")
    public String getGte() {
        return this.gte;
    }

    @GraphQLField
    @GraphQLName(value="exists")
    @GraphQLDescription(value="A value to compare the node property value to, using the 'exists' operator")
    public Boolean getExists() {
        return this.exists;
    }

    @GraphQLField
    @GraphQLName(value="lastDays")
    @GraphQLDescription(value="A value to pick the last days for node property date value, using the 'lastDays' operator")
    public Integer getLastDays() {
        return this.lastDays;
    }

    @GraphQLField
    @GraphQLName(value="all")
    @GraphQLDescription(value="A list of child constraint input for all composition")
    public List<GqlJcrNodeConstraintInput> getAll() {
        return this.all;
    }

    @GraphQLField
    @GraphQLName(value="any")
    @GraphQLDescription(value="A list of child constraint input for any composition")
    public List<GqlJcrNodeConstraintInput> getAny() {
        return this.any;
    }

    @GraphQLField
    @GraphQLName(value="none")
    @GraphQLDescription(value="A list of child constraint input for none composition")
    public List<GqlJcrNodeConstraintInput> getNone() {
        return this.none;
    }

    public static enum QueryFunction {
        LOWER_CASE,
        UPPER_CASE,
        NODE_NAME,
        NODE_LOCAL_NAME;

    }

    public static enum FieldNames {
        LIKE("like"),
        CONTAINS("contains"),
        EQUALS("equals"),
        NOTEQUALS("notEquals"),
        LT("lt"),
        GT("gt"),
        LTE("lte"),
        GTE("gte"),
        EXISTS("exists"),
        LASTDAYS("lastDays"),
        ALL("all"),
        ANY("any"),
        NONE("none");

        private String value;

        public String getValue() {
            return this.value;
        }

        private FieldNames(String value) {
            this.value = value;
        }
    }
}

