/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.node;

import graphql.schema.DataFetchingEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.servlet.http.Part;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.io.FileUtils;
import org.jahia.modules.graphql.provider.dxm.BaseGqlClientException;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNodeInput;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrPropertyInput;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrPropertyOption;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrWrongInputException;
import org.jahia.modules.graphql.provider.dxm.node.NodeHelper;
import org.jahia.modules.graphql.provider.dxm.node.NodeMutationConstraintViolationHandler;
import org.jahia.modules.graphql.provider.dxm.upload.UploadHelper;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.importexport.ImportExportBaseService;
import org.jahia.utils.EncryptionUtils;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class GqlJcrMutationSupport {
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";

    public static JCRNodeWrapper addNode(JCRNodeWrapper parent, GqlJcrNodeInput node) {
        JCRNodeWrapper jcrNode;
        try {
            String nodeName = JCRContentUtils.escapeLocalNodeName((String)node.getName());
            Boolean useAvailableNodeName = node.useAvailableNodeName();
            if (useAvailableNodeName != null && useAvailableNodeName.booleanValue()) {
                nodeName = JCRContentUtils.findAvailableNodeName((Node)parent, (String)nodeName);
            }
            jcrNode = parent.addNode(nodeName, node.getPrimaryNodeType());
            if (node.getMixins() != null) {
                for (String mixin : node.getMixins()) {
                    jcrNode.addMixin(mixin);
                }
            }
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
        if (node.getProperties() != null) {
            GqlJcrMutationSupport.setProperties(jcrNode, node.getProperties());
        }
        if (node.getChildren() != null) {
            for (GqlJcrNodeInput child : node.getChildren()) {
                GqlJcrMutationSupport.addNode(jcrNode, child);
            }
        }
        return jcrNode;
    }

    public static List<JCRPropertyWrapper> setProperties(JCRNodeWrapper node, Collection<GqlJcrPropertyInput> properties) {
        try {
            HashMap<String, JCRSessionWrapper> sessions = new HashMap<String, JCRSessionWrapper>();
            ArrayList<JCRPropertyWrapper> result = new ArrayList<JCRPropertyWrapper>();
            for (GqlJcrPropertyInput property : properties) {
                int type;
                JCRNodeWrapper localizedNode = NodeHelper.getNodeInLanguage(node, property.getLanguage());
                JCRSessionWrapper session = localizedNode.getSession();
                sessions.put(property.getLanguage(), session);
                int n = type = property.getType() != null ? property.getType().getValue() : 1;
                if (property.getValue() != null) {
                    Value v = GqlJcrMutationSupport.getValue(type, property.getOption(), property.getValue(), session, null);
                    result.add(localizedNode.setProperty(property.getName(), v));
                    continue;
                }
                if (property.getValues() == null) continue;
                ArrayList<Value> values = new ArrayList<Value>();
                if (property.getValues() != null) {
                    for (String value : property.getValues()) {
                        values.add(GqlJcrMutationSupport.getValue(type, property.getOption(), value, session, null));
                    }
                }
                result.add(localizedNode.setProperty(property.getName(), values.toArray(new Value[0])));
            }
            for (JCRSessionWrapper session : sessions.values()) {
                session.validate();
            }
            return result;
        }
        catch (IOException | RepositoryException | FileUploadBase.FileSizeLimitExceededException e) {
            throw NodeMutationConstraintViolationHandler.transformException(e);
        }
    }

    public static JCRNodeWrapper getNodeFromPathOrId(JCRSessionWrapper session, String pathOrId) {
        try {
            return '/' == pathOrId.charAt(0) ? session.getNode(JCRContentUtils.escapeNodePath((String)pathOrId)) : session.getNodeByIdentifier(pathOrId);
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    public static void importFileUpload(String partName, JCRNodeWrapper node, DataFetchingEnvironment environment) throws BaseGqlClientException {
        GqlJcrMutationSupport.importFileUpload(partName, node, 2, environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importFileUpload(String partName, JCRNodeWrapper node, int rootBehaviour, DataFetchingEnvironment environment) throws BaseGqlClientException {
        try {
            Part part = UploadHelper.getFileUpload(partName, environment);
            ImportExportBaseService importExportBaseService = ImportExportBaseService.getInstance();
            switch (part.getContentType()) {
                case "application/x-zip-compressed": 
                case "application/zip": {
                    File fileToImport = File.createTempFile("import", ".zip");
                    try {
                        FileUtils.copyInputStreamToFile((InputStream)part.getInputStream(), (File)fileToImport);
                        importExportBaseService.importZip(node.getPath(), (Resource)new FileSystemResource(fileToImport), rootBehaviour);
                        break;
                    }
                    finally {
                        FileUtils.deleteQuietly((File)fileToImport);
                    }
                }
                case "text/xml": {
                    importExportBaseService.importXML(node.getPath(), part.getInputStream(), rootBehaviour);
                    break;
                }
                default: {
                    throw new GqlJcrWrongInputException("Wrong file type");
                }
            }
        }
        catch (Exception e) {
            throw new DataFetchingException(e);
        }
    }

    public static Value getValue(int jcrType, GqlJcrPropertyOption option, String value, JCRSessionWrapper session, DataFetchingEnvironment environment) throws RepositoryException, FileUploadBase.FileSizeLimitExceededException, IOException {
        ValueFactory valueFactory = session.getValueFactory();
        if (option == GqlJcrPropertyOption.ENCRYPTED && jcrType == 1) {
            return valueFactory.createValue(EncryptionUtils.passwordBaseEncrypt((String)value), jcrType);
        }
        if (option == GqlJcrPropertyOption.NOT_ZONED_DATE) {
            try {
                SimpleDateFormat defaultDateFormat = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
                Date date = defaultDateFormat.parse(value);
                return valueFactory.createValue(simpleDateFormat.format(date), jcrType);
            }
            catch (ParseException e) {
                throw new GqlJcrWrongInputException("Unable to parse the date value", e);
            }
        }
        switch (jcrType) {
            case 9: {
                return valueFactory.createValue((Node)GqlJcrMutationSupport.getNodeFromPathOrId(session, value));
            }
            case 10: {
                return valueFactory.createValue((Node)GqlJcrMutationSupport.getNodeFromPathOrId(session, value), true);
            }
            case 2: {
                if (UploadHelper.isValidFileUpload(value, environment)) {
                    return valueFactory.createValue(valueFactory.createBinary(UploadHelper.getFileUpload(value, environment).getInputStream()));
                }
                return valueFactory.createValue(value, jcrType);
            }
        }
        return valueFactory.createValue(value, jcrType);
    }
}

