/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.instrumentation;

import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.kickstart.execution.config.InstrumentationProvider;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jahia.modules.graphql.provider.dxm.config.DXGraphQLConfig;
import org.jahia.modules.graphql.provider.dxm.instrumentation.JCRInstrumentation;
import org.jahia.modules.graphql.provider.dxm.instrumentation.JahiaInstrumentation;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true)
public class JCRInstrumentationProvider
implements InstrumentationProvider {
    private DXGraphQLConfig dxGraphQLConfig;
    private List<JahiaInstrumentation> instrumentations = new ArrayList<JahiaInstrumentation>();

    @Reference
    public void bindDxGraphQLConfig(DXGraphQLConfig dxGraphQLConfig) {
        this.dxGraphQLConfig = dxGraphQLConfig;
    }

    @Reference(service=JahiaInstrumentation.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, unbind="unbindInstrumentation")
    public void bindInstrumentations(JahiaInstrumentation instrumentation) {
        this.instrumentations.add(instrumentation);
    }

    public void unbindInstrumentation(JahiaInstrumentation instrumentation) {
        this.instrumentations.remove(instrumentation);
    }

    public Instrumentation getInstrumentation() {
        ArrayList<JCRInstrumentation> instns = new ArrayList<JCRInstrumentation>();
        instns.add(new JCRInstrumentation(this.dxGraphQLConfig));
        instns.addAll(this.instrumentations.stream().sorted(Comparator.comparingInt(JahiaInstrumentation::getPriority)).map(inst -> inst.getInstrumentation(this.dxGraphQLConfig)).filter(Objects::nonNull).collect(Collectors.toList()));
        return new ChainedInstrumentation(instns);
    }
}

