/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.instrumentation;

import graphql.execution.ExecutionContext;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.schema.DataFetcher;
import javax.servlet.http.HttpServletRequest;
import org.jahia.modules.graphql.provider.dxm.config.DXGraphQLConfig;
import org.jahia.modules.graphql.provider.dxm.osgi.OSGIServiceInjectorDataFetcher;
import org.jahia.modules.graphql.provider.dxm.security.GqlJcrPermissionDataFetcher;
import org.jahia.modules.graphql.provider.dxm.util.ContextUtil;

public class JCRInstrumentation
extends SimpleInstrumentation {
    public static final String GRAPHQL_VARIABLES = "graphQLVariables";
    public static final String FRAGMENTS_BY_NAME = "fragmentsByName";
    private DXGraphQLConfig dxGraphQLConfig;

    JCRInstrumentation(DXGraphQLConfig dxGraphQLConfig) {
        this.dxGraphQLConfig = dxGraphQLConfig;
    }

    public DataFetcher<?> instrumentDataFetcher(DataFetcher<?> dataFetcher, InstrumentationFieldFetchParameters parameters) {
        return super.instrumentDataFetcher(new GqlJcrPermissionDataFetcher(new OSGIServiceInjectorDataFetcher(dataFetcher), this.dxGraphQLConfig.getPermissions()), parameters);
    }

    public ExecutionContext instrumentExecutionContext(ExecutionContext executionContext, InstrumentationExecutionParameters parameters) {
        HttpServletRequest servletRequest = ContextUtil.getHttpServletRequest((executionContext = super.instrumentExecutionContext(executionContext, parameters)).getContext());
        if (servletRequest != null) {
            servletRequest.setAttribute(GRAPHQL_VARIABLES, (Object)executionContext.getVariables());
            servletRequest.setAttribute(FRAGMENTS_BY_NAME, (Object)executionContext.getFragmentsByName());
        }
        return executionContext;
    }
}

