/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.admin;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import java.util.Calendar;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.stream.Streams;
import org.apache.jackrabbit.util.ISO8601;
import org.jahia.bin.Jahia;
import org.jahia.modules.graphql.provider.dxm.acl.GqlAclRole;
import org.jahia.modules.graphql.provider.dxm.acl.service.JahiaAclService;
import org.jahia.modules.graphql.provider.dxm.admin.GqlCluster;
import org.jahia.modules.graphql.provider.dxm.admin.GqlJahiaAdminQuery;
import org.jahia.modules.graphql.provider.dxm.osgi.annotations.GraphQLOsgiService;
import org.jahia.modules.graphql.provider.dxm.security.GraphQLRequiresPermission;
import org.jahia.settings.SettingsBean;

@GraphQLName(value="AdminQuery")
@GraphQLDescription(value="Admin queries root")
public class GqlAdminQuery {
    @Inject
    @GraphQLOsgiService
    private JahiaAclService aclService;

    @GraphQLField
    @GraphQLNonNull
    @GraphQLDescription(value="Get Jahia admin query")
    @GraphQLRequiresPermission(value="graphqlAdminQuery")
    public GqlJahiaAdminQuery getJahia() {
        return new GqlJahiaAdminQuery();
    }

    @Deprecated
    @GraphQLField
    @GraphQLNonNull
    @GraphQLDescription(value="Version of the running Jahia instance")
    public String getVersion() {
        return Jahia.getFullProductVersion();
    }

    @GraphQLField
    @GraphQLDescription(value="Current datetime")
    public String getDatetime() {
        return ISO8601.format((Calendar)Calendar.getInstance());
    }

    @GraphQLField
    @GraphQLDescription(value="Get available ACL roles; does not include any hidden or privileged roles")
    public List<GqlAclRole> getRoles() throws RepositoryException {
        return (List)Streams.stream(this.aclService.getRoles()).map(GqlAclRole::new).collect(Collectors.toList());
    }

    @GraphQLField
    @GraphQLDescription(value="Details about the Jahia cluster")
    public GqlCluster getCluster() {
        GqlCluster gqlCluster = new GqlCluster();
        gqlCluster.setIsActivated(SettingsBean.getInstance().isClusterActivated());
        return gqlCluster;
    }
}

