/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.acl.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.acl.service.JahiaAclRoleProperties;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRValueWrapper;

public class JahiaAclRole {
    private final JCRNodeWrapper roleNode;
    private final String roleName;
    private final Map<String, JahiaAclRoleProperties> i18nProperties = new TreeMap<String, JahiaAclRoleProperties>();

    public JahiaAclRole(JCRNodeWrapper node) throws RepositoryException {
        this.roleNode = node;
        String uuid = node.getIdentifier();
        this.roleName = node.getName();
        this.setI18nProperties(node.getExistingLocales(), uuid);
    }

    private void setI18nProperties(List<Locale> locales, String uuid) throws RepositoryException {
        for (Locale l : locales) {
            JCRNodeWrapper n = this.getSession(l).getNodeByIdentifier(uuid);
            this.i18nProperties.put(l.getLanguage(), new JahiaAclRoleProperties(n));
        }
    }

    public String getName() {
        return this.roleName;
    }

    public String getLabel(String locale) {
        JahiaAclRoleProperties i18nProps = this.i18nProperties.get(locale);
        return i18nProps != null ? i18nProps.getLabel() : null;
    }

    public String getRoleGroup() throws RepositoryException {
        return this.roleNode.hasProperty("j:roleGroup") ? this.roleNode.getPropertyAsString("j:roleGroup") : null;
    }

    public String getDescription(String locale) {
        JahiaAclRoleProperties i18nProps = this.i18nProperties.get(locale);
        return i18nProps != null ? i18nProps.getDescription() : null;
    }

    public List<JahiaAclRole> getDependencies() throws RepositoryException {
        ArrayList<JahiaAclRole> result = new ArrayList<JahiaAclRole>();
        if (this.roleNode.hasProperty("j:dependencies")) {
            JCRValueWrapper[] dependencies;
            for (JCRValueWrapper d : dependencies = this.roleNode.getProperty("j:dependencies").getValues()) {
                result.add(new JahiaAclRole(d.getNode()));
            }
        }
        return result;
    }

    private JCRSessionWrapper getSession(Locale locale) throws RepositoryException {
        return JCRSessionFactory.getInstance().getCurrentUserSession("default", locale);
    }

    public boolean isHidden() throws RepositoryException {
        return this.roleNode.hasProperty("j:hidden") && this.roleNode.getProperty("j:hidden").getBoolean();
    }

    public boolean isPrivileged() {
        return this.roleNode.getName().equals("privileged");
    }
}

