/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.acl;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import java.util.List;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.acl.service.JahiaAclRole;

@GraphQLName(value="AclRole")
@GraphQLDescription(value="GraphQL representation of a Jahia ACL role")
public class GqlAclRole {
    private final JahiaAclRole aclRole;

    public GqlAclRole(JahiaAclRole node) {
        this.aclRole = node;
    }

    @GraphQLField
    @GraphQLDescription(value="Role name")
    public String getName() {
        return this.aclRole.getName();
    }

    @GraphQLField
    @GraphQLDescription(value="Role group")
    public String getRoleGroup() throws RepositoryException {
        return this.aclRole.getRoleGroup();
    }

    @GraphQLField
    @GraphQLDescription(value="Role label for a given locale")
    public String getLabel(@GraphQLName(value="locale") @GraphQLDescription(value="locale") String locale) {
        return this.aclRole.getLabel(locale);
    }

    @GraphQLField
    @GraphQLDescription(value="Role description for a given locale")
    public String getDescription(@GraphQLName(value="locale") @GraphQLDescription(value="locale") String locale) {
        return this.aclRole.getDescription(locale);
    }

    @GraphQLField
    @GraphQLDescription(value="List of dependencies for a given role")
    public List<GqlAclRole> getDependencies() throws RepositoryException {
        return this.aclRole.getDependencies().stream().map(GqlAclRole::new).collect(Collectors.toList());
    }
}

