/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.acl;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.acl.GqlAclEntry;
import org.jahia.modules.graphql.provider.dxm.acl.service.JahiaAclService;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNodeImpl;
import org.jahia.modules.graphql.provider.dxm.osgi.annotations.GraphQLOsgiService;
import org.jahia.modules.graphql.provider.dxm.user.PrincipalInput;
import org.jahia.services.content.JCRNodeWrapper;

@GraphQLName(value="GqlAcl")
@GraphQLDescription(value="ACL properties and list of access control entry")
public class GqlAcl {
    @Inject
    @GraphQLOsgiService
    private JahiaAclService aclService;
    private final JCRNodeWrapper parentNode;

    public GqlAcl(JCRNodeWrapper parent) {
        this.parentNode = parent;
    }

    @GraphQLField
    @GraphQLDescription(value="Get parent node for this ACL")
    public GqlJcrNode getParentNode() {
        return new GqlJcrNodeImpl(this.parentNode);
    }

    @GraphQLField
    @GraphQLDescription(value="Get inheritance break attribute for this node")
    public boolean getInheritanceBreak() throws RepositoryException {
        return this.parentNode.getAclInheritanceBreak();
    }

    @GraphQLField
    @GraphQLDescription(value="Get list of access control entries for this ACL")
    public List<GqlAclEntry> getAclEntries(@GraphQLName(value="principalFilter") @GraphQLDescription(value="Fetch ACL entry only for this principal") PrincipalInput principalInput, @GraphQLName(value="inclInherited") @GraphQLDescription(value="The languages to check") Boolean inclInherited) {
        Stream<Object> s;
        Stream stream = s = principalInput == null ? this.aclService.getAclEntries(this.parentNode).stream() : this.aclService.getAclEntries(this.parentNode, principalInput.getPrincipalKey()).stream();
        if (Boolean.FALSE.equals(inclInherited)) {
            s = s.filter(ace -> !ace.isInherited());
        }
        return s.map(GqlAclEntry::new).collect(Collectors.toList());
    }
}

