/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm;

import graphql.kickstart.execution.GraphQLObjectMapper;
import graphql.kickstart.execution.GraphQLQueryInvoker;
import graphql.kickstart.execution.subscriptions.GraphQLSubscriptionInvocationInputFactory;
import graphql.kickstart.execution.subscriptions.SubscriptionProtocolFactory;
import graphql.kickstart.execution.subscriptions.apollo.ApolloSubscriptionProtocolFactory;
import graphql.kickstart.execution.subscriptions.apollo.OperationMessage;
import graphql.kickstart.servlet.GraphQLWebsocketServlet;
import graphql.kickstart.servlet.input.GraphQLInvocationInputFactory;
import graphql.kickstart.servlet.subscriptions.WebSocketSubscriptionProtocolFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.HandshakeResponse;
import javax.websocket.Session;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.jahia.modules.graphql.provider.dxm.util.BeanWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.usermanager.JahiaUser;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/graphqlws", subprotocols={"graphql-ws", "graphql-transport-ws"}, configurator=Configurator.class)
@Component(immediate=true, service={Endpoint.class})
public class OsgiGraphQLWsEndpoint
extends Endpoint {
    private Logger logger = LoggerFactory.getLogger(OsgiGraphQLWsEndpoint.class);
    private GraphQLWebsocketServlet delegate;
    private WebSocketSubscriptionProtocolFactory subscriptionProtocolFactory;

    @Reference(service=HttpServlet.class, target="(component.name=graphql.kickstart.servlet.OsgiGraphQLHttpServlet)")
    public void setServlet(HttpServlet servlet) {
        try {
            GraphQLQueryInvoker queryInvoker = (GraphQLQueryInvoker)this.getter(servlet, "getQueryInvoker");
            GraphQLInvocationInputFactory invocationInputFactory = (GraphQLInvocationInputFactory)this.getter(servlet, "getInvocationInputFactory");
            GraphQLObjectMapper graphQLObjectMapper = (GraphQLObjectMapper)this.getter(servlet, "getGraphQLObjectMapper");
            this.delegate = new GraphQLWebsocketServlet(queryInvoker.toGraphQLInvoker(), (GraphQLSubscriptionInvocationInputFactory)invocationInputFactory, graphQLObjectMapper);
            this.subscriptionProtocolFactory = BeanWrapper.wrap(this.delegate).call("getSubscriptionProtocolFactory", new Class[]{List.class}, new Object[]{Collections.singletonList("graphql-ws")}).unwrap(WebSocketSubscriptionProtocolFactory.class);
        }
        catch (Exception e) {
            this.logger.error("Cannot get schema from GQL servlet", (Throwable)e);
        }
    }

    @Deactivate
    public void deactivate() {
        try {
            BeanWrapper.wrap(this.subscriptionProtocolFactory).get("commandProvider", ApolloSubscriptionProtocolFactory.class).call("getByType", new Class[]{OperationMessage.Type.class}, new Object[]{OperationMessage.Type.GQL_START}).get("connectionListeners").call("iterator").call("next").get("keepAliveRunner").get("executor").call("shutdown");
        }
        catch (ReflectiveOperationException e) {
            this.logger.error("Cannot get schema from GQL servlet", (Throwable)e);
        }
        this.delegate.beginShutDown();
    }

    private Object getter(Object object, String getter) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = object.getClass().getDeclaredMethod(getter, new Class[0]);
        method.setAccessible(true);
        return method.invoke(object, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(Session session, EndpointConfig endpointConfig) {
        Map userProperties = endpointConfig.getUserProperties();
        userProperties.put(SubscriptionProtocolFactory.class.getName(), this.subscriptionProtocolFactory);
        JCRSessionFactory.getInstance().setCurrentUser((JahiaUser)userProperties.get("org.jahia.usermanager.jahiauser"));
        try {
            this.delegate.onOpen(session, endpointConfig);
        }
        finally {
            JCRSessionFactory.getInstance().setCurrentUser(null);
        }
    }

    public void onClose(Session session, CloseReason closeReason) {
        this.delegate.onClose(session, closeReason);
    }

    public void onError(Session session, Throwable thr) {
        this.delegate.onError(session, thr);
    }

    public static class Configurator
    extends ServerEndpointConfig.Configurator {
        public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
            sec.getUserProperties().put("org.jahia.usermanager.jahiauser", JCRSessionFactory.getInstance().getCurrentUser());
        }
    }
}

