/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm;

import graphql.ExecutionResult;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.FetchedValue;
import graphql.execution.FieldValueInfo;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.SubscriptionExecutionStrategy;
import graphql.kickstart.servlet.context.DefaultGraphQLWebSocketContext;
import java.util.concurrent.CompletableFuture;
import org.jahia.bin.filters.jcr.JcrSessionFilter;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.usermanager.JahiaUser;

public class JahiaSubscriptionExecutionStrategy
extends SubscriptionExecutionStrategy {
    public JahiaSubscriptionExecutionStrategy(DataFetcherExceptionHandler exceptionHandler) {
        super(exceptionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<ExecutionResult> execute(ExecutionContext executionContext, ExecutionStrategyParameters parameters) throws NonNullableFieldWasNullException {
        try {
            DefaultGraphQLWebSocketContext context = (DefaultGraphQLWebSocketContext)executionContext.getContext();
            JCRSessionFactory.getInstance().setCurrentUser((JahiaUser)context.getSession().getUserProperties().get("org.jahia.usermanager.jahiauser"));
            CompletableFuture completableFuture = super.execute(executionContext, parameters);
            return completableFuture;
        }
        finally {
            JcrSessionFilter.endRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FieldValueInfo completeField(ExecutionContext executionContext, ExecutionStrategyParameters parameters, FetchedValue fetchedValue) {
        boolean resetUser = false;
        if (JCRSessionFactory.getInstance().getCurrentUser() == null) {
            DefaultGraphQLWebSocketContext context = (DefaultGraphQLWebSocketContext)executionContext.getContext();
            JCRSessionFactory.getInstance().setCurrentUser((JahiaUser)context.getSession().getUserProperties().get("org.jahia.usermanager.jahiauser"));
            resetUser = true;
        }
        try {
            FieldValueInfo fieldValueInfo = super.completeField(executionContext, parameters, fetchedValue);
            return fieldValueInfo;
        }
        finally {
            if (resetUser) {
                JcrSessionFilter.endRequest();
            }
        }
    }
}

