/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm;

import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import graphql.execution.AsyncSerialExecutionStrategy;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.FetchedValue;
import graphql.execution.FieldValueInfo;
import graphql.language.SourceLocation;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.jahia.modules.graphql.provider.dxm.DXGraphQLError;
import org.jahia.modules.graphql.provider.dxm.DXGraphQLFieldCompleter;
import org.jahia.modules.graphql.provider.dxm.GqlReadOnlyModeException;
import org.jahia.modules.graphql.provider.dxm.JahiaDataFetchingExceptionHandler;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaMutationExecutionStrategy
extends AsyncSerialExecutionStrategy {
    private static final Logger logger = LoggerFactory.getLogger(JahiaMutationExecutionStrategy.class);

    public JahiaMutationExecutionStrategy(DataFetcherExceptionHandler exceptionHandler) {
        super(exceptionHandler);
    }

    public CompletableFuture<ExecutionResult> execute(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        if (SettingsBean.getInstance().isFullReadOnlyMode()) {
            String message = "Operation is not permitted as DX is in read-only mode";
            logger.warn(message);
            DXGraphQLError error = new DXGraphQLError(new GqlReadOnlyModeException(message), parameters.getPath().toList(), new ArrayList<SourceLocation>());
            return CompletableFuture.completedFuture(new ExecutionResultImpl((GraphQLError)error));
        }
        return super.execute(executionContext, parameters);
    }

    protected FieldValueInfo completeField(ExecutionContext executionContext, ExecutionStrategyParameters parameters, FetchedValue fetchedValue) {
        FieldValueInfo result = super.completeField(executionContext, parameters, fetchedValue);
        Object value = fetchedValue.getFetchedValue();
        if (value instanceof DXGraphQLFieldCompleter && executionContext.getErrors().isEmpty()) {
            try {
                ((DXGraphQLFieldCompleter)value).completeField();
            }
            catch (Exception e) {
                SourceLocation sourceLocation = parameters.getField().getSingleField().getSourceLocation();
                GraphQLError error = JahiaDataFetchingExceptionHandler.transformException(e, parameters.getPath(), sourceLocation);
                executionContext.addError(error, parameters.getPath());
            }
        }
        return result;
    }
}

