/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import graphql.annotations.processor.GraphQLAnnotationsComponent;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.retrievers.GraphQLExtensionsHandler;
import graphql.annotations.processor.retrievers.GraphQLFieldRetriever;
import graphql.annotations.processor.retrievers.GraphQLInterfaceRetriever;
import graphql.annotations.processor.retrievers.GraphQLObjectInfoRetriever;
import graphql.annotations.processor.retrievers.GraphQLTypeRetriever;
import graphql.annotations.processor.searchAlgorithms.SearchAlgorithm;
import graphql.annotations.processor.typeFunctions.TypeFunction;
import graphql.kickstart.servlet.osgi.GraphQLCodeRegistryProvider;
import graphql.kickstart.servlet.osgi.GraphQLMutationProvider;
import graphql.kickstart.servlet.osgi.GraphQLProvider;
import graphql.kickstart.servlet.osgi.GraphQLQueryProvider;
import graphql.kickstart.servlet.osgi.GraphQLSubscriptionProvider;
import graphql.kickstart.servlet.osgi.GraphQLTypesProvider;
import graphql.relay.Relay;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.PropertyDataFetcher;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import org.jahia.bin.filters.jcr.JcrSessionFilter;
import org.jahia.modules.graphql.provider.dxm.DXGraphQLExtensionsProvider;
import org.jahia.modules.graphql.provider.dxm.UnboxingTypeFunction;
import org.jahia.modules.graphql.provider.dxm.config.DXGraphQLConfig;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNodeConnection;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNodeImpl;
import org.jahia.modules.graphql.provider.dxm.node.SpecializedType;
import org.jahia.modules.graphql.provider.dxm.node.SpecializedTypesHandler;
import org.jahia.modules.graphql.provider.dxm.relay.DXConnection;
import org.jahia.modules.graphql.provider.dxm.relay.DXRelay;
import org.jahia.modules.graphql.provider.dxm.sdl.parsing.SDLSchemaService;
import org.jahia.modules.graphql.provider.dxm.security.JahiaGraphQLFieldRetriever;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.securityfilter.PermissionService;
import org.jahia.services.usermanager.JahiaUser;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={GraphQLProvider.class}, immediate=true)
public class DXGraphQLProvider
implements GraphQLTypesProvider,
GraphQLQueryProvider,
GraphQLMutationProvider,
GraphQLCodeRegistryProvider,
DXGraphQLExtensionsProvider,
GraphQLSubscriptionProvider {
    private static Logger logger = LoggerFactory.getLogger(DXGraphQLProvider.class);
    private static DXGraphQLProvider instance;
    private SpecializedTypesHandler specializedTypesHandler;
    private GraphQLAnnotationsComponent graphQLAnnotations;
    private GraphQLTypeRetriever graphQLTypeRetriever;
    private GraphQLObjectInfoRetriever graphQLObjectInfoRetriever;
    private GraphQLInterfaceRetriever graphQLInterfaceRetriever;
    private GraphQLFieldRetriever graphQLFieldRetriever;
    private SearchAlgorithm fieldSearchAlgorithm;
    private SearchAlgorithm methodSearchAlgorithm;
    private GraphQLExtensionsHandler extensionsHandler;
    private DXGraphQLConfig dxGraphQLConfig;
    private ProcessingElementsContainer container;
    private static Map<String, URL> sdlResources;
    private Collection<DXGraphQLExtensionsProvider> extensionsProviders = new HashSet<DXGraphQLExtensionsProvider>();
    private GraphQLObjectType queryType;
    private GraphQLObjectType mutationType;
    private GraphQLObjectType subscriptionType;
    private GraphQLCodeRegistry codeRegistry;
    private DXRelay relay;
    private Map<String, Class<? extends DXConnection<?>>> connectionTypes = new HashMap();
    private SDLSchemaService sdlSchemaService;
    private PermissionService permissionService;
    private Executor executor;
    private ExecutorService pool;
    private TypeFunction defaultTypeFunction;
    private TypeFunction unboxingTypeFunction;

    public static DXGraphQLProvider getInstance() {
        return instance;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policyOption=ReferencePolicyOption.GREEDY)
    public void setGraphQLAnnotations(GraphQLAnnotationsComponent graphQLAnnotations) {
        this.graphQLAnnotations = graphQLAnnotations;
    }

    public GraphQLAnnotationsComponent getGraphQLAnnotations() {
        return this.graphQLAnnotations;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policyOption=ReferencePolicyOption.GREEDY)
    public void setGraphQLTypeRetriever(GraphQLTypeRetriever graphQLTypeRetriever) {
        this.graphQLTypeRetriever = graphQLTypeRetriever;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policyOption=ReferencePolicyOption.GREEDY)
    public void setGraphQLObjectInfoRetriever(GraphQLObjectInfoRetriever graphQLObjectInfoRetriever) {
        this.graphQLObjectInfoRetriever = graphQLObjectInfoRetriever;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policyOption=ReferencePolicyOption.GREEDY)
    public void setGraphQLInterfaceRetriever(GraphQLInterfaceRetriever graphQLInterfaceRetriever) {
        this.graphQLInterfaceRetriever = graphQLInterfaceRetriever;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policyOption=ReferencePolicyOption.GREEDY)
    public void setGraphQLFieldRetriever(GraphQLFieldRetriever graphQLFieldRetriever) {
        this.graphQLFieldRetriever = graphQLFieldRetriever;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, target="(type=field)", policyOption=ReferencePolicyOption.GREEDY)
    public void setFieldSearchAlgorithm(SearchAlgorithm fieldSearchAlgorithm) {
        this.fieldSearchAlgorithm = fieldSearchAlgorithm;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, target="(type=method)", policyOption=ReferencePolicyOption.GREEDY)
    public void setMethodSearchAlgorithm(SearchAlgorithm methodSearchAlgorithm) {
        this.methodSearchAlgorithm = methodSearchAlgorithm;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policyOption=ReferencePolicyOption.GREEDY)
    public void setExtensionsHandler(GraphQLExtensionsHandler extensionsHandler) {
        this.extensionsHandler = extensionsHandler;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policyOption=ReferencePolicyOption.GREEDY)
    public void setSDLRegistrationService(SDLSchemaService sdlSchemaService) {
        this.sdlSchemaService = sdlSchemaService;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policyOption=ReferencePolicyOption.GREEDY)
    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public ProcessingElementsContainer getContainer() {
        return this.container;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY)
    public void addExtensionProvider(DXGraphQLExtensionsProvider provider) {
        logger.debug("Adding extension : {}", (Object)provider.toString());
        this.extensionsProviders.add(provider);
        this.registerSchema();
    }

    public void removeExtensionProvider(DXGraphQLExtensionsProvider provider) {
        logger.debug("Removing extension : {}", (Object)provider.toString());
        this.extensionsProviders.remove(provider);
        this.registerSchema();
    }

    @Reference
    public void setDxGraphQLConfig(DXGraphQLConfig dxGraphQLConfig) {
        this.dxGraphQLConfig = dxGraphQLConfig;
    }

    @Activate
    public void activate() {
        if (logger.isDebugEnabled()) {
            logger.debug("Activating GraphQL API schema with extensions {}", (Object)this.extensionsProviders.stream().map(dxGraphQLExtensionsProvider -> dxGraphQLExtensionsProvider.getClass().getSimpleName()).collect(Collectors.joining(",")));
        }
        instance = this;
        this.pool = new ForkJoinPool(50);
        this.executor = command -> {
            JahiaUser user = JCRSessionFactory.getInstance().getCurrentUser();
            Collection scopes = this.permissionService.getCurrentScopes();
            this.pool.execute(() -> {
                JCRSessionFactory.getInstance().setCurrentUser(user);
                this.permissionService.setCurrentScopes(scopes);
                try {
                    command.run();
                }
                finally {
                    JcrSessionFilter.endRequest();
                    this.permissionService.resetScopes();
                }
            });
        };
        JahiaGraphQLFieldRetriever graphQLFieldWithPermissionsRetriever = new JahiaGraphQLFieldRetriever(this.dxGraphQLConfig, this.graphQLFieldRetriever, this.executor);
        this.graphQLTypeRetriever.setGraphQLObjectInfoRetriever(this.graphQLObjectInfoRetriever);
        this.graphQLTypeRetriever.setGraphQLInterfaceRetriever(this.graphQLInterfaceRetriever);
        this.graphQLTypeRetriever.setGraphQLFieldRetriever((GraphQLFieldRetriever)graphQLFieldWithPermissionsRetriever);
        this.graphQLTypeRetriever.setFieldSearchAlgorithm(this.fieldSearchAlgorithm);
        this.graphQLTypeRetriever.setMethodSearchAlgorithm(this.methodSearchAlgorithm);
        this.graphQLTypeRetriever.setExtensionsHandler(this.extensionsHandler);
        this.graphQLFieldRetriever.setAlwaysPrettify(true);
        this.container = this.graphQLAnnotations.createContainer();
        this.specializedTypesHandler = new SpecializedTypesHandler(this.graphQLAnnotations, this.container);
        ((UnboxingTypeFunction)this.unboxingTypeFunction).setDefaultTypeFunction(this.defaultTypeFunction);
        this.relay = new DXRelay();
        this.sdlSchemaService.setRelay(this.relay);
        this.container.setRelay((Relay)this.relay);
        this.connectionTypes.put("JCRNodeConnection", GqlJcrNodeConnection.class);
        for (Map.Entry<String, Class<DXConnection<?>>> entry : this.connectionTypes.entrySet()) {
            this.relay.addConnectionType(entry.getKey(), (GraphQLObjectType)this.graphQLAnnotations.getOutputTypeProcessor().getOutputTypeOrRef(entry.getValue(), this.container));
        }
        this.extensionsProviders.add(this);
        this.registerSchema();
    }

    private void registerSchema() {
        if (instance != null && this.graphQLAnnotations != null && this.graphQLTypeRetriever != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Registering GraphQL API schema with extensions {}", (Object)this.extensionsProviders.stream().map(dxGraphQLExtensionsProvider -> dxGraphQLExtensionsProvider.getClass().getSimpleName()).collect(Collectors.joining(",")));
            }
            GraphQLExtensionsHandler extensionsHandler = this.graphQLAnnotations.getExtensionsHandler();
            extensionsHandler.setFieldRetriever(this.graphQLTypeRetriever.getGraphQLFieldRetriever());
            this.registerSchema(extensionsHandler);
        }
    }

    private void registerSchema(GraphQLExtensionsHandler extensionsHandler) {
        this.sdlSchemaService.clearExtensions();
        for (DXGraphQLExtensionsProvider extensionsProvider : this.extensionsProviders) {
            try {
                this.sdlSchemaService.addExtensions(extensionsProvider);
                for (Class<?> clazz : extensionsProvider.getExtensions()) {
                    if (!clazz.isAnnotationPresent(GraphQLTypeExtension.class)) continue;
                    extensionsHandler.registerTypeExtension(clazz, this.container);
                    if (clazz.isAnnotationPresent(GraphQLDescription.class)) {
                        logger.debug("Registered type extension {}: {}", clazz, (Object)clazz.getAnnotation(GraphQLDescription.class).value());
                        continue;
                    }
                    logger.debug("Registered type extension {}", clazz);
                }
                for (Class<Object> clazz : extensionsProvider.getSpecializedTypes()) {
                    SpecializedType annotation = clazz.getAnnotation(SpecializedType.class);
                    if (annotation != null) {
                        this.specializedTypesHandler.addType(annotation.value(), clazz);
                        continue;
                    }
                    logger.error("No annotation found on class " + clazz);
                }
            }
            catch (Throwable e) {
                logger.error("Unable to register extension for provider {} because {}", (Object)extensionsProvider.getClass().getName(), (Object)e.getCause().toString());
                logger.debug("full error", e);
            }
        }
        this.queryType = (GraphQLObjectType)this.graphQLAnnotations.getOutputTypeProcessor().getOutputTypeOrRef(Query.class, this.container);
        this.mutationType = (GraphQLObjectType)this.graphQLAnnotations.getOutputTypeProcessor().getOutputTypeOrRef(Mutation.class, this.container);
        this.subscriptionType = (GraphQLObjectType)this.graphQLAnnotations.getOutputTypeProcessor().getOutputTypeOrRef(Subscription.class, this.container);
        this.codeRegistry = this.container.getCodeRegistryBuilder().build();
        for (DXGraphQLExtensionsProvider extensionsProvider : this.extensionsProviders) {
            for (Class<Object> clazz : extensionsProvider.getExtensions()) {
                if (!clazz.isAnnotationPresent(GraphQLTypeExtension.class)) continue;
                extensionsHandler.registerTypeExtension(clazz, this.container);
                logger.debug("Registered type extension {}", clazz);
            }
        }
        this.sdlSchemaService.refreshSpecialInputTypes(this.graphQLAnnotations, this.container);
        this.sdlSchemaService.generateSchema();
        this.specializedTypesHandler.initializeTypes();
        PropertyDataFetcher.clearReflectionCache();
    }

    @Deactivate
    public void deactivate() {
        this.pool.shutdown();
    }

    public Collection<GraphQLType> getTypes() {
        ArrayList<GraphQLType> types = new ArrayList<GraphQLType>();
        types.add((GraphQLType)this.graphQLAnnotations.getOutputTypeProcessor().getOutputTypeOrRef(GqlJcrNodeImpl.class, this.container));
        types.addAll(this.specializedTypesHandler.getKnownTypes().values());
        types.addAll(this.sdlSchemaService.getSDLTypes());
        return types;
    }

    public Collection<GraphQLFieldDefinition> getQueries() {
        ArrayList<GraphQLFieldDefinition> defs = new ArrayList<GraphQLFieldDefinition>(this.queryType.getFieldDefinitions());
        defs.addAll(this.sdlSchemaService.getSDLQueries());
        return defs;
    }

    public Collection<GraphQLFieldDefinition> getMutations() {
        return this.mutationType.getFieldDefinitions();
    }

    public Collection<GraphQLFieldDefinition> getSubscriptions() {
        return this.subscriptionType.getFieldDefinitions();
    }

    public GraphQLCodeRegistry getCodeRegistry() {
        return this.codeRegistry;
    }

    public Class<? extends DXConnection<?>> getConnectionType(String connectionName) {
        return this.connectionTypes.get(connectionName);
    }

    public GraphQLOutputType getOutputType(Class<?> clazz) {
        return this.graphQLAnnotations.getOutputTypeProcessor().getOutputTypeOrRef(clazz, this.container);
    }

    @Reference(target="(type=default)", policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setDefaultTypeFunction(TypeFunction defaultTypeFunction) {
        this.defaultTypeFunction = defaultTypeFunction;
    }

    public void unsetDefaultTypeFunction(TypeFunction defaultTypeFunction) {
        this.defaultTypeFunction = null;
    }

    @Reference(target="(type=unboxing)", policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setUnboxingTypeFunction(TypeFunction unboxingTypeFunction) {
        this.unboxingTypeFunction = unboxingTypeFunction;
    }

    public void unsetUnboxingTypeFunction(TypeFunction unboxingTypeFunction) {
        this.defaultTypeFunction = null;
    }

    static {
        sdlResources = new ConcurrentHashMap<String, URL>();
    }

    @GraphQLName(value="Subscription")
    public static class Subscription {
    }

    @GraphQLName(value="Mutation")
    public static class Mutation {
    }

    @GraphQLName(value="Query")
    public static class Query {
    }
}

