/**
 * 
 * This file is part of Jahia: An integrated WCM, DMS and Portal Solution
 * Copyright (C) 2002-2014 Jahia Limited. All rights reserved.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * As a special exception to the terms and conditions of version 2.0 of
 * the GPL (or any later version), you may redistribute this Program in connection
 * with Free/Libre and Open Source Software ("FLOSS") applications as described
 * in Jahia's FLOSS exception. You should have received a copy of the text
 * describing the FLOSS exception, and it is also available here:
 * http://www.jahia.com/license
 * 
 * Commercial and Supported Versions of the program
 * Alternatively, commercial and supported versions of the program may be used
 * in accordance with the terms contained in a separate written agreement
 * between you and Jahia Limited. If you are unsure which license is appropriate
 * for your use, please contact the sales department at sales@jahia.com.
 */

package org.jahia.configuration.deployers;

import java.io.File;
import java.io.IOException;

/**
 * Server deployer interface. 
 * @author Serge Huber
 */
public interface ServerDeploymentInterface {

    /**
     * Performs the deployment of a JDBC driver JAR file.
     * 
     * @param driverJar
     *            the driver JAR file to be deployed
     * @return <code>true</code> in case of successful deployment; <code>false</code> otherwise
     * @throws IOException
     *             in case of an I/O error
     */
    boolean deployJdbcDriver(File driverJar) throws IOException;

    boolean deploySharedLibraries(File... pathToLibraries) throws IOException;

    File getDeploymentBaseDir();

    File getDeploymentDirPath(String name, String type);
    
    File getDeploymentFilePath(String name, String type);

    String getName();

    File getTargetServerDirectory();

    /**
     * Returns the excludes pattern for the Jahia WAR artifact, comma separated.
     * Can return null to indicate that nothing should be excluded.
     * 
     * @return the excludes pattern for the Jahia WAR artifact, comma separated;
     *         can return null to indicate that nothing should be excluded
     */
    String getWarExcludes();

    String getWebappDeploymentDirNameOverride();
    
    /**
     * Returns <code>true</code> if the server supports auto deployment of
     * packaged WAR files, required for new portlet deployment.
     * 
     * @return <code>true</code> if the server supports auto deployment of
     *         packaged WAR files, required for new portlet deployment.
     */
    boolean isAutoDeploySupported();
    
    /**
     * Returns <code>true</code> if the application server uses EAR deployment instead of WAR.
     * 
     * @return <code>true</code> if the application server uses EAR deployment; otherwise returns <code>false</code>
     */
    boolean isEarDeployment();
    
    boolean undeploySharedLibraries(File... pathToLibraries) throws IOException;
    
    /**
     * Returns <code>true</code> if the server target directory indeed contains a valid installation of the application server
     * @return <code>true</code> if the server target directory indeed contains a valid installation of the application server
     */
    boolean validateInstallationDirectory();
}
