/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.commons.encryption;

import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.jasypt.contrib.org.apache.commons.codec_1_3.binary.Base64;
import org.jasypt.digest.StringDigester;
import org.jasypt.salt.RandomSaltGenerator;

public class PBKDF2Digester
implements StringDigester {
    private static final char HASH_SEPARATOR = '$';
    private static final PBKDF2Digester INSTANCE = new PBKDF2Digester();
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private int hashSizeBytes = 32;
    private String id = "p";
    private int iterations = 8192;
    private RandomSaltGenerator saltGenerator = new RandomSaltGenerator();
    private int saltSizeBytes = 64;

    public static PBKDF2Digester getInstance() {
        return INSTANCE;
    }

    public String digest(String message) {
        byte[] salt = this.saltGenerator.generateSalt(this.saltSizeBytes);
        StringBuilder result = new StringBuilder(133);
        return result.append(new String(Base64.encodeBase64((byte[])salt, (boolean)false), UTF_8)).append('$').append(this.hash(message, salt)).toString();
    }

    private byte[] doHash(String pwd, byte[] salt) {
        if (pwd == null || pwd.length() == 0) {
            throw new IllegalArgumentException("Empty passwords are not supported.");
        }
        SecretKey key = null;
        try {
            SecretKeyFactory f = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            key = f.generateSecret(new PBEKeySpec(pwd.toCharArray(), salt, this.iterations, this.hashSizeBytes * 8));
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException(e);
        }
        return Base64.encodeBase64((byte[])key.getEncoded(), (boolean)false);
    }

    public String getId() {
        return this.id;
    }

    private String hash(String pwd, byte[] salt) {
        return new String(this.doHash(pwd, salt), UTF_8);
    }

    public boolean matches(String message, String digest) {
        if (message == null || digest == null) {
            return false;
        }
        int pos = digest.indexOf(36);
        if (pos == -1) {
            throw new IllegalArgumentException("Digest of improper format");
        }
        byte[] salt = Base64.decodeBase64((byte[])digest.substring(0, pos).getBytes(UTF_8));
        byte[] hash = this.doHash(message, salt);
        return MessageDigest.isEqual(digest.substring(pos + 1).getBytes(UTF_8), hash);
    }

    public void setHashSizeBytes(int hashSizeBytes) {
        this.hashSizeBytes = hashSizeBytes;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public void setSaltGenerator(RandomSaltGenerator saltGenerator) {
        this.saltGenerator = saltGenerator;
    }

    public void setSaltSizeBytes(int saltSizeBytes) {
        this.saltSizeBytes = saltSizeBytes;
    }
}

