/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.lang.reflect.Field;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.Constants;
import org.instancio.internal.util.Format;
import org.instancio.internal.util.StringUtils;
import org.instancio.settings.AssignmentType;
import org.instancio.settings.Keys;
import org.instancio.settings.OnSetFieldError;
import org.instancio.settings.OnSetMethodError;
import org.instancio.settings.OnSetMethodNotFound;
import org.instancio.settings.SetterStyle;
import org.instancio.settings.Settings;

public final class ErrorMessageUtils {
    private static final int INITIAL_SB_SIZE = 1024;

    private ErrorMessageUtils() {
    }

    public static String unableToGetValueFromField(Field field, Object target) {
        return new StringBuilder(300).append("unable to get value from field.").append(Constants.NL).append(Constants.NL).append(" -> Field........: ").append(field).append(Constants.NL).append(" -> Target type..: ").append(target.getClass()).append(Constants.NL).append(Constants.NL).append("If you think this is a bug, please submit a bug report including the stacktrace:").append(Constants.NL).append("https://github.com/instancio/instancio/issues").toString();
    }

    public static String unableToResolveFieldFromMethodRef(Class<?> targetClass, String lambdaImplMethodName) {
        String at = Format.firstNonInstancioStackTraceLine(new Throwable());
        return new StringBuilder(1024).append(Constants.NL).append(Constants.NL).append("Unable to resolve the field from method reference:").append(Constants.NL).append("-> ").append(Format.withoutPackage(targetClass)).append("::").append(lambdaImplMethodName).append(Constants.NL).append("   at ").append(at).append(Constants.NL).append(Constants.NL).append("Potential causes:").append(Constants.NL).append("-> The method and the corresponding field do not follow expected naming conventions").append(Constants.NL).append("   See: https://www.instancio.org/user-guide/#method-reference-selector").append(Constants.NL).append("-> The method is abstract, declared in a superclass, and the field is declared in a subclass").append(Constants.NL).append("-> The method reference is expressed as a lambda function").append(Constants.NL).append("   Example:     field((SamplePojo pojo) -> pojo.getValue())").append(Constants.NL).append("   Instead of:  field(SamplePojo::getValue)").append(Constants.NL).append("-> You are using Kotlin and passing a method reference of a Kotlin class").append(Constants.NL).append(Constants.NL).append("Possible solutions:").append(Constants.NL).append("-> Resolve the above issues, if applicable").append(Constants.NL).append("-> Specify the field name explicitly, e.g.").append(Constants.NL).append("   field(Example.class, \"someField\")").append(Constants.NL).append("-> If using Kotlin, consider creating a 'KSelect' utility class, for example:").append(Constants.NL).append(Constants.NL).append("   class KSelect {").append(Constants.NL).append("       companion object {").append(Constants.NL).append("           fun <T, V> field(property: KProperty1<T, V>): TargetSelector {").append(Constants.NL).append("               val field = property.javaField!!").append(Constants.NL).append("               return Select.field(field.declaringClass, field.name)").append(Constants.NL).append("           }").append(Constants.NL).append("       }").append(Constants.NL).append("   }").append(Constants.NL).append(Constants.NL).append("   Usage: KSelect.field(SamplePojo::value)").append(Constants.NL).toString();
    }

    public static String createSetterSelectorWithFieldAssignmentErrorMessage(String selectorLocation) {
        return new StringBuilder(512).append("setter() selector cannot be used with AssignmentType.FIELD:").append(Constants.NL).append(" -> ").append(selectorLocation).append(Constants.NL).append(Constants.NL).append("Root cause:").append(Constants.NL).append(Constants.NL).append("Instancio provides the 'Keys.ASSIGNMENT_TYPE' setting that").append(Constants.NL).append("determines how objects are populated. The setting supports two options:").append(Constants.NL).append(Constants.NL).append(" -> AssignmentType.FIELD (default behaviour)").append(Constants.NL).append("    Objects are populated via fields only. Setter methods are ignored.").append(Constants.NL).append("    This is the recommended setting for most uses cases.").append(Constants.NL).append(Constants.NL).append(" -> AssignmentType.METHOD").append(Constants.NL).append("    Objects are populated via methods and (optionally) fields.").append(Constants.NL).append(Constants.NL).append("Using setter() selectors is only supported with METHOD assignment.").append(Constants.NL).append(Constants.NL).append("    // Example").append(Constants.NL).append("    Settings settings = Settings.create()").append(Constants.NL).append("        .set(Keys.ASSIGNMENT_TYPE, AssignmentType.METHOD);").append(Constants.NL).append(Constants.NL).append("    Pojo pojo = Instancio.of(Pojo.class)").append(Constants.NL).append("        .withSettings(settings)").append(Constants.NL).append("        .set(setter(Pojo::setValue), \"foo\")").append(Constants.NL).append("        .create();").append(Constants.NL).append(Constants.NL).append("See https://www.instancio.org/user-guide/#assignment-settings for details").toString();
    }

    public static String getTypeMismatchErrorMessage(Object value, InternalNode node) {
        return ErrorMessageUtils.getTypeMismatchErrorMessage(value, node, null);
    }

    public static String getTypeMismatchErrorMessage(Object value, InternalNode node, Throwable cause) {
        StringBuilder sb = new StringBuilder(1024).append("error assigning value to: ").append(Format.nodePathToRootBlock(node)).append(Constants.NL).append(Constants.NL).append(Constants.NL);
        ErrorMessageUtils.appendTypeMismatchDetails(value, node, sb);
        if (cause != null) {
            sb.append(Constants.NL).append(Constants.NL).append("Root cause:").append(Constants.NL).append(" -> ").append(ErrorMessageUtils.getRootCause(cause));
        }
        return sb.toString();
    }

    public static String getContainerElementMismatchMessage(String errorMsg, Object value, InternalNode containerNode, InternalNode elementNode) {
        StringBuilder sb = new StringBuilder(1024).append(errorMsg).append(": ").append(Format.nodePathToRootBlock(containerNode)).append(Constants.NL).append(Constants.NL).append(Constants.NL);
        ErrorMessageUtils.appendTypeMismatchDetails(value, elementNode, sb);
        return sb.toString();
    }

    public static String abstractRootWithoutSubtype(Class<?> klass) {
        return new StringBuilder(1024).append("could not create an instance of ").append(klass).append(Constants.NL).append(Constants.NL).append("Cause:").append(Constants.NL).append(Constants.NL).append(" -> It is an abstract class and no subtype was provided").append(Constants.NL).append(Constants.NL).append("To resolve this error:").append(Constants.NL).append(Constants.NL).append(" -> Specify the subtype using the builder API:").append(Constants.NL).append(Constants.NL).append("    AbstractPojo pojo = Instancio.of(AbstractPojo.class)").append(Constants.NL).append("        .subtype(all(AbstractPojo.class), ConcretePojo.class)").append(Constants.NL).append("        .create();").append(Constants.NL).append(Constants.NL).append(" -> Or alternatively, specify the subtype using Settings:").append(Constants.NL).append(Constants.NL).append("    Settings settings = Settings.create()").append(Constants.NL).append("        .mapType(AbstractPojo.class, ConcretePojo.class);").append(Constants.NL).append(Constants.NL).append("    AbstractPojo pojo = Instancio.of(AbstractPojo.class)").append(Constants.NL).append("        .withSettings(settings)").append(Constants.NL).append("        .create();").append(Constants.NL).append(Constants.NL).append("For more information see: https://www.instancio.org/user-guide/#subtype-mapping").toString();
    }

    public static String collectionCouldNotBePopulated(ModelContext<?> context, InternalNode node, int targetSize) {
        Settings settings = context.getSettings();
        return new StringBuilder(1024).append("unable to populate Collection of size ").append(targetSize).append(": ").append(Format.nodePathToRootBlock(node)).append(Constants.NL).append(Constants.NL).append(Constants.NL).append("Could not generate enough elements to populate the collection.").append(Constants.NL).append("This typically occurs with Sets when the number of potential values is").append(Constants.NL).append("limited and the target set cannot be generated due to duplicate element").append(Constants.NL).append("values, for example:").append(Constants.NL).append(Constants.NL).append(" -> The element type is an enum").append(Constants.NL).append(Constants.NL).append(" -> The element type is a POJO, but blank POJOs are being generated").append(Constants.NL).append("    because the configured maximum depth has been reached").append(Constants.NL).append(Constants.NL).append(" -> The element is an abstract type and no subtype was specified.").append(Constants.NL).append("    See https://www.instancio.org/user-guide/#subtype-mapping for details").append(Constants.NL).append(Constants.NL).append("Model properties:").append(Constants.NL).append(Constants.NL).append(" -> Collection target size: ").append(targetSize).append(Constants.NL).append(Constants.NL).append("    The size was either chosen randomly based on current settings,").append(Constants.NL).append("    or may have been specified explicitly via the API.").append(Constants.NL).append(Constants.NL).append(" -> Current size settings are").append(Constants.NL).append(Constants.NL).append("    Keys.COLLECTION_MIN_SIZE: ").append(settings.get(Keys.COLLECTION_MIN_SIZE)).append(Constants.NL).append("    Keys.COLLECTION_MAX_SIZE: ").append(settings.get(Keys.COLLECTION_MAX_SIZE)).append(Constants.NL).append(Constants.NL).append(" -> Keys.MAX_DEPTH: ").append(settings.get(Keys.MAX_DEPTH)).append(Constants.NL).append(Constants.NL).append(" -> Model max depth: ").append(context.getMaxDepth()).append(Constants.NL).append(Constants.NL).append("    Unless overridden using withMaxDepth() method,").append(Constants.NL).append("    this value should be the same as Keys.MAX_DEPTH").append(Constants.NL).append(Constants.NL).append("For more information see: https://www.instancio.org/user-guide/#error-handling").toString();
    }

    public static String mapCouldNotBePopulated(ModelContext<?> context, InternalNode node, int targetSize) {
        Settings settings = context.getSettings();
        return new StringBuilder(1024).append("unable to populate Map of size ").append(targetSize).append(": ").append(Format.nodePathToRootBlock(node)).append(Constants.NL).append(Constants.NL).append(Constants.NL).append("Could not generate enough entries to populate the map.").append(Constants.NL).append("This occurs when the number of potential map keys is limited").append(Constants.NL).append("and the target map cannot be generated due to duplicate keys,").append(Constants.NL).append("for example:").append(Constants.NL).append(Constants.NL).append(" -> The key type is an enum").append(Constants.NL).append(Constants.NL).append(" -> The key type is a POJO, but blank POJOs are being generated").append(Constants.NL).append("    because the configured maximum depth has been reached").append(Constants.NL).append(Constants.NL).append(" -> The key or value is an abstract type and no subtype was specified.").append(Constants.NL).append("    See https://www.instancio.org/user-guide/#subtype-mapping for details").append(Constants.NL).append(Constants.NL).append("Model properties:").append(Constants.NL).append(Constants.NL).append(" -> Map target size: ").append(targetSize).append(Constants.NL).append(Constants.NL).append("    The size was either chosen randomly based on current settings,").append(Constants.NL).append("    or may have been specified explicitly via the API.").append(Constants.NL).append(Constants.NL).append(" -> Current size settings are").append(Constants.NL).append(Constants.NL).append("    Keys.MAP_MIN_SIZE: ").append(settings.get(Keys.MAP_MIN_SIZE)).append(Constants.NL).append("    Keys.MAP_MAX_SIZE: ").append(settings.get(Keys.MAP_MAX_SIZE)).append(Constants.NL).append(Constants.NL).append(" -> Keys.MAX_DEPTH: ").append(settings.get(Keys.MAX_DEPTH)).append(Constants.NL).append(Constants.NL).append(" -> Model max depth: ").append(context.getMaxDepth()).append(Constants.NL).append(Constants.NL).append("    Unless overridden using withMaxDepth() method,").append(Constants.NL).append("    this value should be the same as Keys.MAX_DEPTH").append(Constants.NL).append(Constants.NL).append("For more information see: https://www.instancio.org/user-guide/#error-handling").toString();
    }

    private static void appendTypeMismatchDetails(Object value, InternalNode node, StringBuilder sb) {
        String nodeDescription = Format.formatNode(node);
        String argType = Format.withoutPackage(value.getClass());
        String argValue = StringUtils.quoteToString(value);
        sb.append("Type mismatch:").append(Constants.NL).append(Constants.NL);
        if (node.getField() == null) {
            sb.append(" -> Target type ..............: ");
        } else {
            sb.append(" -> Target field .............: ");
        }
        sb.append(nodeDescription).append(Constants.NL).append(" -> Provided argument type ...: ").append(argType).append(Constants.NL).append(" -> Provided argument value ..: ").append(argValue);
    }

    public static String incompatibleField(Object value, Field field, Throwable cause, Settings settings) {
        OnSetFieldError onSetFieldError = settings.get(Keys.ON_SET_FIELD_ERROR);
        String fieldName = Format.formatField(field);
        String argType = Format.withoutPackage(value.getClass());
        String argValue = StringUtils.quoteToString(value);
        return new StringBuilder(1024).append(Constants.NL).append("Throwing exception because:").append(Constants.NL).append(" -> Keys.ON_SET_FIELD_ERROR = ").append((Object)onSetFieldError).append(Constants.NL).append(Constants.NL).append("Error assigning value to field:").append(Constants.NL).append(Constants.NL).append(" -> Target field: ............: ").append(fieldName).append(Constants.NL).append(" -> Provided argument type ...: ").append(argType).append(Constants.NL).append(" -> Provided argument value ..: ").append(argValue).append(Constants.NL).append(Constants.NL).append("Root cause:").append(Constants.NL).append(" -> ").append(ErrorMessageUtils.getRootCause(cause)).append(Constants.NL).append(Constants.NL).append("To ignore the error and leave the field uninitialised").append(Constants.NL).append(" -> Update Keys.ON_SET_FIELD_ERROR setting to: ").append((Object)OnSetFieldError.IGNORE).append(Constants.NL).toString();
    }

    public static String setterNotFound(InternalNode node, Settings settings) {
        String fieldName = Format.formatField(node.getField());
        SetterStyle setterStyle = settings.get(Keys.SETTER_STYLE);
        OnSetMethodNotFound onSetMethodNotFound = settings.get(Keys.ON_SET_METHOD_NOT_FOUND);
        return new StringBuilder(1024).append(Constants.NL).append("Throwing exception because:").append(Constants.NL).append(" -> Keys.ASSIGNMENT_TYPE = ").append((Object)AssignmentType.METHOD).append(Constants.NL).append(" -> Keys.ON_SET_METHOD_NOT_FOUND = ").append((Object)onSetMethodNotFound).append(Constants.NL).append(Constants.NL).append("Setter method could not be resolved for field:").append(Constants.NL).append(" -> ").append(fieldName).append(Constants.NL).append(Constants.NL).append("Using:").append(Constants.NL).append(" -> Keys.SETTER_STYLE = ").append((Object)setterStyle).append(Constants.NL).append(Constants.NL).append("To resolve the error, consider one of the following:").append(Constants.NL).append(" -> Add the expected setter method").append(Constants.NL).append(" -> Update Keys.ON_SET_METHOD_NOT_FOUND setting to:").append(Constants.NL).append("    -> ").append((Object)OnSetMethodNotFound.ASSIGN_FIELD).append(" to assign value via field").append(Constants.NL).append("    -> ").append((Object)OnSetMethodNotFound.IGNORE).append(" to leave value uninitialised").append(Constants.NL).toString();
    }

    public static String getSetterInvocationErrorMessage(Object value, String method, Throwable cause, Settings settings) {
        OnSetMethodError onSetMethodError = settings.get(Keys.ON_SET_METHOD_ERROR);
        String argType = value == null ? "n/a" : Format.withoutPackage(value.getClass());
        String argValue = StringUtils.quoteToString(value);
        return new StringBuilder(1024).append(Constants.NL).append("Throwing exception because:").append(Constants.NL).append(" -> Keys.ASSIGNMENT_TYPE = ").append((Object)AssignmentType.METHOD).append(Constants.NL).append(" -> Keys.ON_SET_METHOD_ERROR = ").append((Object)onSetMethodError).append(Constants.NL).append(Constants.NL).append("Method invocation failed:").append(Constants.NL).append(Constants.NL).append(" -> Method ...................: ").append(method).append(Constants.NL).append(" -> Provided argument type ...: ").append(argType).append(Constants.NL).append(" -> Provided argument value ..: ").append(argValue).append(Constants.NL).append(Constants.NL).append("Root cause:").append(Constants.NL).append(" -> ").append(ErrorMessageUtils.getRootCause(cause)).append(Constants.NL).append(Constants.NL).append("To resolve the error, consider one of the following:").append(Constants.NL).append(" -> Address the root cause that triggered the exception").append(Constants.NL).append(" -> Update Keys.ON_SET_METHOD_ERROR setting to").append(Constants.NL).append("    -> ").append((Object)OnSetMethodError.ASSIGN_FIELD).append(" to assign value via field").append(Constants.NL).append("    -> ").append((Object)OnSetMethodError.IGNORE).append(" to leave value uninitialised").append(Constants.NL).toString();
    }

    public static String selectorNotNullErrorMessage(String message, String methodName, String invokedMethods, Throwable t) {
        String template = "%n  %s%n  method invocation: %s%n  at %s";
        String invocation = String.format("%s.%s( -> null <- )", invokedMethods, methodName);
        String at = Format.firstNonInstancioStackTraceLine(t);
        return String.format("%n  %s%n  method invocation: %s%n  at %s", message, invocation, at);
    }

    private static Throwable getRootCause(Throwable t) {
        Throwable cause = t;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }
}

