/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.instancio.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static boolean isNullOrEmpty(@Nullable Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNullOrEmpty(@Nullable Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    @SafeVarargs
    public static <T> List<T> asUnmodifiableList(T ... values) {
        return Collections.unmodifiableList(CollectionUtils.asArrayList(values));
    }

    @SafeVarargs
    public static <T> List<T> asArrayList(T ... values) {
        return values == null ? new ArrayList() : new ArrayList<T>(Arrays.asList(values));
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... values) {
        if (values == null) {
            return Collections.emptySet();
        }
        HashSet set = new HashSet(values.length);
        Collections.addAll(set, values);
        return set;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> asLinkedHashMap(Function<V, K> keyFn, V ... values) {
        if (values == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(values.length);
        for (V value : values) {
            K key = keyFn.apply(value);
            map.put(key, value);
        }
        return map;
    }

    @SafeVarargs
    public static <T> List<T> combine(List<T> list, T ... values) {
        ArrayList<T> result = new ArrayList<T>(list);
        Collections.addAll(result, values);
        return Collections.unmodifiableList(result);
    }

    public static <T> List<T> flatMap(List<List<T>> lists) {
        if (lists.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> results = new ArrayList<T>();
        for (List<T> list : lists) {
            results.addAll(list);
        }
        return results;
    }

    public static int identityIndexOf(Object obj, @NotNull List<?> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != obj) continue;
            return i;
        }
        return -1;
    }

    public static <T> void shuffle(Collection<T> collection, Random random) {
        if (collection.isEmpty()) {
            return;
        }
        if (collection instanceof List) {
            CollectionUtils.shuffleList((List)collection, random);
            return;
        }
        ArrayList<T> list = new ArrayList<T>(collection);
        CollectionUtils.shuffleList(list, random);
        collection.clear();
        collection.addAll(list);
    }

    private static <T> void shuffleList(List<T> list, Random random) {
        for (int i = 0; i < list.size(); ++i) {
            int r = random.intRange(0, i);
            T tmp = list.get(i);
            list.set(i, list.get(r));
            list.set(r, tmp);
        }
    }
}

