/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.settings;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.settings.AutoAdjustable;
import org.instancio.internal.settings.InternalKey;
import org.instancio.internal.settings.SettingsSupport;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.ReflectionUtils;
import org.instancio.settings.Keys;
import org.instancio.settings.SettingKey;
import org.instancio.settings.Settings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InternalSettings
implements Settings {
    private static final String TYPE_MAPPING_PREFIX = "subtype.";
    private static final boolean AUTO_ADJUST_ENABLED = true;
    private boolean isLockedForModifications;
    private Map<SettingKey<?>, Object> settingsMap = new HashMap();
    private Map<Class<?>, Class<?>> subtypeMap = new HashMap();

    InternalSettings() {
    }

    public static InternalSettings create() {
        return new InternalSettings();
    }

    public static InternalSettings defaults() {
        InternalSettings settings = new InternalSettings();
        for (SettingKey<Object> setting : Keys.all()) {
            settings.set((SettingKey)setting, setting.defaultValue());
        }
        return settings;
    }

    public static InternalSettings from(Map<Object, Object> map) {
        InternalSettings settings = new InternalSettings();
        map.forEach((k, v) -> {
            String key = k.toString();
            if (key.startsWith(TYPE_MAPPING_PREFIX)) {
                String fromClass = key.replace(TYPE_MAPPING_PREFIX, "");
                settings.mapType((Class)ReflectionUtils.getClass(fromClass), (Class)ReflectionUtils.getClass(v.toString()));
            } else {
                SettingKey settingKey = Keys.get(key);
                if (settingKey == null) {
                    settingKey = new InternalKey(key, null, null, null, true, false);
                    settings.set(settingKey, v);
                } else {
                    settings.set(settingKey, InternalSettings.convertValueToKeyType(settingKey, v));
                }
            }
        });
        return settings;
    }

    public static InternalSettings from(Settings other) {
        InternalSettings settings = new InternalSettings();
        settings.settingsMap.putAll(((InternalSettings)other).settingsMap);
        settings.subtypeMap.putAll(((InternalSettings)other).subtypeMap);
        return settings;
    }

    @Override
    public InternalSettings merge(@Nullable Settings other) {
        InternalSettings merged = InternalSettings.create();
        merged.settingsMap.putAll(this.settingsMap);
        merged.subtypeMap.putAll(this.subtypeMap);
        if (other != null) {
            merged.settingsMap.putAll(((InternalSettings)other).settingsMap);
            merged.subtypeMap.putAll(((InternalSettings)other).subtypeMap);
        }
        return merged;
    }

    @Override
    public <T> T get(@NotNull SettingKey<T> key) {
        Object value = this.settingsMap.get(ApiValidator.notNull(key, "Key must not be null", new Object[0]));
        if (value == null || key.type() == null || key.type().isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        return InternalSettings.convertValueToKeyType(key, value);
    }

    @Override
    public <T> InternalSettings set(SettingKey<T> key, T value) {
        return this.set(key, value, true);
    }

    <T> InternalSettings set(SettingKey<T> key, @Nullable T value, boolean autoAdjust) {
        this.checkLockedForModifications();
        ApiValidator.validateKeyValue(key, value);
        this.settingsMap.put(key, value);
        if (autoAdjust && value != null && key instanceof AutoAdjustable) {
            Optional<SettingKey<SettingKey>> adjustable = SettingsSupport.getAutoAdjustable(key);
            adjustable.ifPresent(settingKey -> ((AutoAdjustable)((Object)settingKey)).autoAdjust(this, new NumberCaster().cast(value)));
        }
        return this;
    }

    @Override
    public InternalSettings mapType(@NotNull Class<?> type, @NotNull Class<?> subtype) {
        this.checkLockedForModifications();
        ApiValidator.validateSubtype(type, subtype);
        this.subtypeMap.put(type, subtype);
        return this;
    }

    @Override
    public Map<Class<?>, Class<?>> getSubtypeMap() {
        return Collections.unmodifiableMap(this.subtypeMap);
    }

    @Override
    public InternalSettings lock() {
        if (!this.isLockedForModifications) {
            this.settingsMap = Collections.unmodifiableMap(this.settingsMap);
            this.subtypeMap = Collections.unmodifiableMap(this.subtypeMap);
            this.isLockedForModifications = true;
        }
        return this;
    }

    @Override
    public boolean isLocked() {
        return this.isLockedForModifications;
    }

    private void checkLockedForModifications() {
        if (this.isLockedForModifications) {
            throw new UnsupportedOperationException("This instance of Settings has been locked and is read-only");
        }
    }

    public String toString() {
        return String.format("Settings[%nisLockedForModifications: %s%nsettingsMap:%s%nSettings subtypeMap:%s", this.isLockedForModifications, InternalSettings.mapToString(new TreeMap(this.settingsMap)), InternalSettings.mapToString(this.subtypeMap));
    }

    private static String mapToString(Map<?, ?> map) {
        if (map.isEmpty()) {
            return " {}";
        }
        return "\n" + map.entrySet().stream().map(e -> {
            String key = e.getKey() instanceof SettingKey ? ((SettingKey)e.getKey()).propertyKey() : e.getKey().toString();
            return String.format("\t'%s': %s", key, e.getValue());
        }).collect(Collectors.joining("\n"));
    }

    private static <T> T convertValueToKeyType(SettingKey<T> key, Object value) {
        Function<String, String> fn = SettingsSupport.getFunction(key.type());
        try {
            return fn.apply(value.toString());
        }
        catch (NumberFormatException ex) {
            throw Fail.withUsageError(String.format("invalid value %s (of type %s) for setting key %s", value, value.getClass().getSimpleName(), key), ex);
        }
    }

    private static final class NumberCaster<T extends Number> {
        private NumberCaster() {
        }

        private T cast(Object obj) {
            return (T)((Number)obj);
        }
    }
}

