/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.instancio.GetMethodSelector;
import org.instancio.GroupableSelector;
import org.instancio.Scope;
import org.instancio.SetMethodSelector;
import org.instancio.TargetSelector;
import org.instancio.internal.Flattener;
import org.instancio.internal.selectors.MethodRef;
import org.instancio.internal.selectors.PredicateScopeImpl;
import org.instancio.internal.selectors.PredicateSelectorImpl;
import org.instancio.internal.selectors.PrimitiveAndWrapperSelectorImpl;
import org.instancio.internal.selectors.ScopeImpl;
import org.instancio.internal.selectors.SelectorBuilder;
import org.instancio.internal.selectors.SelectorGroupImpl;
import org.instancio.internal.selectors.SelectorImpl;
import org.instancio.internal.selectors.SetterSelectorHolder;
import org.instancio.internal.selectors.Target;
import org.instancio.internal.selectors.TargetClass;
import org.instancio.internal.selectors.TargetField;
import org.instancio.internal.selectors.TargetFieldName;
import org.instancio.internal.selectors.TargetGetterReference;
import org.instancio.internal.selectors.TargetRoot;
import org.instancio.internal.selectors.TargetSetter;
import org.instancio.internal.selectors.TargetSetterName;
import org.instancio.internal.selectors.TargetSetterReference;
import org.instancio.internal.spi.InternalServiceProvider;
import org.instancio.internal.util.ErrorMessageUtils;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.ObjectUtils;
import org.instancio.internal.util.ReflectionUtils;
import org.instancio.internal.util.Verify;
import org.jetbrains.annotations.NotNull;

public final class SelectorProcessor {
    private final Class<?> rootClass;
    private final List<InternalServiceProvider> internalServiceProviders;
    private final SetterSelectorHolder setMethodSelectorHolder;

    public SelectorProcessor(Class<?> rootClass, List<InternalServiceProvider> internalServiceProviders, SetterSelectorHolder setMethodSelectorHolder) {
        this.rootClass = rootClass;
        this.internalServiceProviders = internalServiceProviders;
        this.setMethodSelectorHolder = setMethodSelectorHolder;
    }

    public List<TargetSelector> process(@NotNull TargetSelector selector) {
        if (selector instanceof SelectorImpl) {
            SelectorImpl result = this.processTargetAndScope((SelectorImpl)selector);
            return Collections.singletonList(result);
        }
        if (selector instanceof SelectorGroupImpl) {
            return this.processGroup((SelectorGroupImpl)selector);
        }
        if (selector instanceof GetMethodSelector) {
            return this.process(SelectorImpl.builder().target(new TargetGetterReference((GetMethodSelector)selector)).build());
        }
        if (selector instanceof SetMethodSelector) {
            return this.process(SelectorImpl.builder().target(new TargetSetterReference((SetMethodSelector)selector)).build());
        }
        if (selector instanceof PrimitiveAndWrapperSelectorImpl) {
            PrimitiveAndWrapperSelectorImpl ps = (PrimitiveAndWrapperSelectorImpl)selector;
            if (ps.isScoped()) {
                List<Scope> scopes = this.createScopeWithRootClass(ps.getPrimitive().getScopes());
                return Arrays.asList(ps.getPrimitive().toBuilder().scopes(scopes).build(), ps.getWrapper().toBuilder().scopes(scopes).build());
            }
            return Arrays.asList(ps.getPrimitive(), ps.getWrapper());
        }
        if (selector instanceof PredicateSelectorImpl) {
            PredicateSelectorImpl ps = (PredicateSelectorImpl)selector;
            PredicateSelectorImpl processed = ps.toBuilder().scopes(this.createScopeWithRootClass(ps.getScopes())).build();
            return Collections.singletonList(processed);
        }
        SelectorBuilder builder = (SelectorBuilder)((Object)selector);
        return Collections.singletonList(builder.build());
    }

    @NotNull
    private SelectorImpl processTargetAndScope(SelectorImpl selector) {
        if (selector.getTarget() instanceof TargetRoot) {
            return selector;
        }
        List<Scope> processedScopes = this.createScopeWithRootClass(selector.getScopes());
        Target target = this.createTargetWithRootClass(selector.getTarget());
        SelectorImpl result = selector.toBuilder().target(target).scopes(processedScopes).build();
        if (result.getTarget() instanceof TargetSetter) {
            this.setMethodSelectorHolder.withSetterSelector(result);
        }
        return result;
    }

    @NotNull
    private Target createTargetWithRootClass(Target target) {
        Target result;
        if (target instanceof TargetFieldName) {
            TargetFieldName t = (TargetFieldName)target;
            Class<?> targetClass = ObjectUtils.defaultIfNull(t.getTargetClass(), this.rootClass);
            Field field = ReflectionUtils.getFieldOrNull(targetClass, t.getFieldName());
            if (field == null) {
                throw Fail.withUsageError(String.format("invalid field '%s' for %s", t.getFieldName(), targetClass), new Object[0]);
            }
            result = new TargetField(field);
        } else if (target instanceof TargetGetterReference) {
            TargetGetterReference t = (TargetGetterReference)target;
            MethodRef mr = MethodRef.from(t.getSelector());
            Field field = this.resolveFieldFromGetterMethodReference(mr.getTargetClass(), mr.getMethodName());
            result = new TargetField(field);
        } else if (target instanceof TargetSetterReference) {
            TargetSetterReference t = (TargetSetterReference)target;
            MethodRef mr = MethodRef.from(t.getSelector());
            Method method = ReflectionUtils.getSetterMethod(mr.getTargetClass(), mr.getMethodName(), null);
            result = new TargetSetter(method);
        } else if (target instanceof TargetSetterName) {
            TargetSetterName t = (TargetSetterName)target;
            Class<?> targetClass = ObjectUtils.defaultIfNull(t.getTargetClass(), this.rootClass);
            Method method = ReflectionUtils.getSetterMethod(targetClass, t.getMethodName(), t.getParameterType());
            result = new TargetSetter(method);
        } else if (target instanceof TargetClass) {
            TargetClass t = (TargetClass)target;
            result = new TargetClass(t.getTargetClass());
        } else {
            result = target;
        }
        return result;
    }

    @NotNull
    private Field resolveFieldFromGetterMethodReference(Class<?> declaringClass, String methodName) {
        for (InternalServiceProvider provider : this.internalServiceProviders) {
            Field field;
            InternalServiceProvider.InternalGetterMethodFieldResolver resolver = provider.getGetterMethodFieldResolver();
            if (resolver == null || (field = resolver.resolveField(declaringClass, methodName)) == null) continue;
            return field;
        }
        throw Fail.withUsageError(ErrorMessageUtils.unableToResolveFieldFromMethodRef(declaringClass, methodName), new Object[0]);
    }

    private List<Scope> createScopeWithRootClass(List<Scope> scopes) {
        if (scopes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Scope> results = new ArrayList<Scope>(scopes.size());
        for (Scope s : scopes) {
            if (s instanceof ScopeImpl) {
                ScopeImpl scope = (ScopeImpl)s;
                Target unprocessed = scope.getTarget();
                Target processed = this.createTargetWithRootClass(unprocessed);
                results.add(new ScopeImpl(processed, scope.getDepth()));
                continue;
            }
            Verify.isTrue(s instanceof PredicateScopeImpl, "expected predicate scope", new Object[0]);
            results.add(s);
        }
        return results;
    }

    private List<TargetSelector> processGroup(SelectorGroupImpl selectorGroup) {
        ArrayList<TargetSelector> results = new ArrayList<TargetSelector>();
        for (GroupableSelector groupMember : selectorGroup.getSelectors()) {
            if (groupMember instanceof Flattener) {
                List flattened = ((Flattener)((Object)groupMember)).flatten();
                for (TargetSelector selector : flattened) {
                    results.addAll(this.process(selector));
                }
                continue;
            }
            SelectorBuilder builder = (SelectorBuilder)((Object)groupMember);
            results.add(builder.build());
        }
        return results;
    }
}

